/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.mrs.masters.entity.MarriageReligion;
import org.egov.mrs.masters.repository.ReligionRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReligionService {
    private final ReligionRepository religionRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ReligionService(ReligionRepository religionRepository) {
        this.religionRepository = religionRepository;
    }

    @Transactional
    public void createReligion(MarriageReligion religion) {
        this.religionRepository.save((Object)religion);
    }

    @Transactional
    public MarriageReligion updateReligion(MarriageReligion religion) {
        return (MarriageReligion)((Object)this.religionRepository.saveAndFlush((Object)religion));
    }

    public MarriageReligion findById(Long id) {
        return this.religionRepository.findById(id);
    }

    public MarriageReligion getReligion(String religionName) {
        return this.religionRepository.findByName(religionName);
    }

    public List<MarriageReligion> getReligions() {
        return this.religionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public MarriageReligion getProxy(Long id) {
        return (MarriageReligion)((Object)this.religionRepository.getOne(id));
    }

    public List<MarriageReligion> findAll() {
        return this.religionRepository.findAll();
    }

    public List<MarriageReligion> searchReligions(MarriageReligion religion) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageReligion.class);
        if (null != religion.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)religion.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return criteria.list();
    }
}

