/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.entity.Source;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.application.service.ReIssueDemandService;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.autonumber.MarriageRegistrationApplicationNumberGenerator;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.repository.ReIssueRepository;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageSmsAndEmailService;
import org.egov.mrs.masters.service.MarriageFeeService;
import org.egov.mrs.service.es.ReIssueCertificateUpdateIndexesService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReIssueService {
    private static final String USER = "user";
    private static final String DEPARTMENT = "department";
    private final ReIssueRepository reIssueRepository;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource mrsMessageSource;
    @Autowired
    private RegistrationWorkflowService workflowService;
    @Autowired
    private ReIssueDemandService reIssueDemandService;
    @Autowired
    private MarriageRegistrationApplicationNumberGenerator marriageRegistrationApplicationNumberGenerator;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private MarriageUtils marriageUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private MarriageFeeService marriageFeeService;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    @Autowired
    private MarriageSmsAndEmailService marriageSmsAndEmailService;
    @Autowired
    private ReIssueCertificateUpdateIndexesService reiSsueUpdateIndexesService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    @Autowired
    public ReIssueService(ReIssueRepository reIssueRepository) {
        this.reIssueRepository = reIssueRepository;
    }

    @Transactional
    public void create(ReIssue reIssue) {
        this.reIssueRepository.save((Object)reIssue);
    }

    @Transactional
    public ReIssue update(ReIssue reIssue) {
        return (ReIssue)((Object)this.reIssueRepository.saveAndFlush((Object)reIssue));
    }

    public ReIssue get(Long id) {
        return this.reIssueRepository.findById(id);
    }

    public ReIssue findByApplicationNo(String applicationNo) {
        return this.reIssueRepository.findByApplicationNo(applicationNo);
    }

    @Transactional
    public String createReIssueApplication(ReIssue reIssue, WorkflowContainer workflowContainer) {
        if (StringUtils.isBlank((CharSequence)reIssue.getApplicationNo())) {
            reIssue.setApplicationNo(this.marriageRegistrationApplicationNumberGenerator.getNextReIssueApplicationNumber(reIssue));
            reIssue.setApplicationDate(new Date());
        }
        if (reIssue.getFeeCriteria() != null) {
            reIssue.setFeeCriteria(this.marriageFeeService.getFee(reIssue.getFeeCriteria().getId()));
        }
        reIssue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.CREATED.toString(), "Marriage Registration"));
        reIssue.setSource(Source.SYSTEM.toString());
        if (reIssue.getFeePaid() != null && reIssue.getDemand() == null) {
            reIssue.setDemand(this.reIssueDemandService.createDemand(new BigDecimal(reIssue.getFeePaid())));
        }
        HashMap<Long, MarriageDocument> applicantDocumentAndId = new HashMap<Long, MarriageDocument>();
        this.marriageDocumentService.getIndividualDocuments().forEach(document -> applicantDocumentAndId.put(document.getId(), (MarriageDocument)((Object)document)));
        this.marriageApplicantService.addDocumentsToFileStore(reIssue.getApplicant(), applicantDocumentAndId);
        this.workflowService.transition(reIssue, workflowContainer, reIssue.getApprovalComent());
        this.create(reIssue);
        this.reiSsueUpdateIndexesService.createReIssueAppIndex(reIssue);
        this.marriageSmsAndEmailService.sendSMSForReIssueApplication(reIssue);
        this.marriageSmsAndEmailService.sendEmailForReIssueApplication(reIssue);
        return reIssue.getApplicationNo();
    }

    @Transactional
    public ReIssue forwardReIssue(Long id, ReIssue reissue, WorkflowContainer workflowContainer) {
        this.updateReIssueData(reissue);
        reissue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.CREATED.toString(), "Marriage Registration"));
        this.update(reissue);
        this.workflowService.transition(reissue, workflowContainer, reissue.getApprovalComent());
        return reissue;
    }

    @Transactional
    public ReIssue approveReIssue(ReIssue reissue, WorkflowContainer workflowContainer) {
        reissue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.APPROVED.toString(), "Marriage Registration"));
        ReIssue reissue1 = this.update(reissue);
        this.workflowService.transition(reissue1, workflowContainer, workflowContainer.getApproverComments());
        this.marriageSmsAndEmailService.sendSMSForReIssueApplication(reissue1);
        this.marriageSmsAndEmailService.sendEmailForReIssueApplication(reissue1);
        this.reiSsueUpdateIndexesService.updateReIssueAppIndex(reissue1);
        return reissue1;
    }

    @Transactional
    public ReIssue rejectReIssue(ReIssue reissue, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        List appConfigValues;
        reissue.setStatus(workflowContainer.getWorkFlowAction().equalsIgnoreCase("Reject") ? this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.REJECTED.toString(), "Marriage Registration") : this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.CANCELLED.toString(), "Marriage Registration"));
        if (workflowContainer.getWorkFlowAction().equalsIgnoreCase("Cancel ReIssue") && (appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "REISSUE_PRINTREJECTIONCERTIFICATE")) != null && !appConfigValues.isEmpty() && "YES".equalsIgnoreCase(((AppConfigValues)appConfigValues.get(0)).getValue())) {
            MarriageCertificate marriageCertificate = this.marriageCertificateService.reIssueCertificate(reissue, request, MarriageCertificateType.REJECTION);
            reissue.addCertificate(marriageCertificate);
        }
        this.reiSsueUpdateIndexesService.updateReIssueAppIndex(reissue);
        this.marriageSmsAndEmailService.sendSMSForReIssueApplication(reissue);
        this.marriageSmsAndEmailService.sendEmailForReIssueApplication(reissue);
        reissue.setRejectionReason(workflowContainer.getApproverComments());
        this.workflowService.transition(reissue, workflowContainer, workflowContainer.getApproverComments());
        return reissue;
    }

    private void updateReIssueData(ReIssue reissue) {
        if (reissue.getFeeCriteria() != null) {
            reissue.setFeeCriteria(this.marriageFeeService.getFee(reissue.getFeeCriteria().getId()));
        }
        reissue.setFeePaid(reissue.getFeePaid());
        if (reissue.getFeePaid() != null) {
            if (reissue.getDemand() == null) {
                reissue.setDemand(this.reIssueDemandService.createDemand(new BigDecimal(reissue.getFeePaid())));
            } else {
                this.reIssueDemandService.updateDemand(reissue.getDemand(), new BigDecimal(reissue.getFeePaid()));
            }
        }
        reissue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.CREATED.toString(), "Marriage Registration"));
        this.updateDocuments(reissue);
    }

    private void updateDocuments(ReIssue reissue) {
        HashMap<Long, MarriageDocument> individualDocumentAndId = new HashMap<Long, MarriageDocument>();
        this.marriageDocumentService.getIndividualDocuments().forEach(document -> individualDocumentAndId.put(document.getId(), (MarriageDocument)((Object)document)));
        this.marriageApplicantService.addDocumentsToFileStore(reissue.getApplicant(), individualDocumentAndId);
    }

    @Transactional
    public MarriageCertificate generateReIssueCertificate(ReIssue reIssue, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        MarriageCertificate marriageCertificate = this.marriageCertificateService.reIssueCertificate(reIssue, request, MarriageCertificateType.REISSUE);
        reIssue.addCertificate(marriageCertificate);
        return marriageCertificate;
    }

    @Transactional
    public ReIssue digiSignCertificate(ReIssue reIssue, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        reIssue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.DIGITALSIGNED.toString(), "Marriage Registration"));
        this.workflowService.transition(reIssue, workflowContainer, workflowContainer.getApproverComments());
        this.reiSsueUpdateIndexesService.updateReIssueAppIndex(reIssue);
        return reIssue;
    }

    @Transactional
    public ReIssue printCertificate(ReIssue reIssue, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        if (reIssue.getMarriageCertificate().isEmpty()) {
            MarriageCertificate marriageCertificate = this.marriageCertificateService.reIssueCertificate(reIssue, request, MarriageCertificateType.REISSUE);
            reIssue.addCertificate(marriageCertificate);
        }
        reIssue.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(ReIssue.ReIssueStatus.CERTIFICATEREISSUED.toString(), "Marriage Registration"));
        reIssue.setActive(true);
        this.workflowService.transition(reIssue, workflowContainer, workflowContainer.getApproverComments());
        return reIssue;
    }

    public List<Map<String, Object>> getHistory(ReIssue reIssue) {
        ArrayList<Map<String, Object>> historyTable = new ArrayList<Map<String, Object>>();
        State state = reIssue.getState();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            User user;
            if (!reIssue.getStateHistory().isEmpty() && reIssue.getStateHistory() != null) {
                Collections.reverse(reIssue.getStateHistory());
            }
            for (StateHistory stateHistory : reIssue.getStateHistory()) {
                HashMap<String, Object> historyMap = new HashMap<String, Object>(0);
                historyMap.put("date", stateHistory.getDateInfo());
                historyMap.put("comments", stateHistory.getComments() != null ? stateHistory.getComments() : "");
                historyMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                historyMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    historyMap.put(USER, user.getUsername() + "::" + user.getName());
                    historyMap.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    historyMap.put(USER, null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    historyMap.put(DEPARTMENT, null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(historyMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put(USER, user.getUsername() + "::" + user.getName());
                map.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put(USER, null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put(DEPARTMENT, null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public boolean checkAnyWorkFlowInProgressForRegistration(MarriageRegistration registration) {
        return this.reIssueRepository.findReIssueInProgressForRegistration(registration.getRegistrationNo()) != null;
    }
}

