/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Embeddable
public class Contact {
    @Pattern(regexp="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$")
    @SafeHtml
    @Length(max=15)
    @Audited
    private String mobileNo;
    @SafeHtml
    @Audited
    @Length(max=128)
    @Email(regexp="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")
    private String email;
    @NotNull
    @SafeHtml
    @Length(max=256)
    private String residenceAddress;
    @SafeHtml
    @Length(max=256)
    private String officeAddress;

    public String getMobileNo() {
        return this.mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getResidenceAddress() {
        return this.residenceAddress;
    }

    public void setResidenceAddress(String residenceAddress) {
        this.residenceAddress = residenceAddress;
    }

    public String getOfficeAddress() {
        return this.officeAddress;
    }

    public void setOfficeAddress(String officeAddress) {
        this.officeAddress = officeAddress;
    }
}

