/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.mrs.application.service.MarriageFeeCalculator;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageFeeType;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.service.MarriageFeeService;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarriageFeeCalculatorImpl
implements MarriageFeeCalculator {
    @Autowired
    private MarriageFeeService marriageFeeService;

    @Override
    public String getFeeType() {
        return MarriageFeeType.MRGREGISTRATION.name();
    }

    @Override
    public Double calculateMarriageRegistrationFee(MarriageRegistration marriageRegistration, Date dateOfMarriage) {
        Double fee = null;
        AppConfigValues allowValidation = this.marriageFeeService.getDaysValidationAppConfValue("Marriage Registration", "MARRIAGEREGISTRATION_DAYS_VALIDATION");
        int days = Days.daysBetween((ReadableInstant)new DateTime((Object)dateOfMarriage), (ReadableInstant)new DateTime((Object)new Date())).getDays();
        if (allowValidation != null && !allowValidation.getValue().isEmpty()) {
            if ("NO".equalsIgnoreCase(allowValidation.getValue())) {
                fee = this.checkMarriageFeeForCriteria(days);
            } else if ("YES".equalsIgnoreCase(allowValidation.getValue()) && days <= 90) {
                fee = this.checkMarriageFeeForCriteria(days);
            }
        }
        return fee;
    }

    private Double checkMarriageFeeForCriteria(int days) {
        List<MarriageFee> fee = this.marriageFeeService.getActiveGeneralTypeFeeses();
        for (MarriageFee marriageFee : fee) {
            if (days < marriageFee.getFromDays() || marriageFee.getToDays() != null && days > marriageFee.getToDays()) continue;
            return marriageFee.getFees();
        }
        return null;
    }

    @Override
    public MarriageFee calculateMarriageReissueFee(ReIssue reIssue, String criteria) {
        return this.marriageFeeService.getFeeForCriteria(criteria);
    }
}

