/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.service.es;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.service.es.MarriageRegistrationIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageRegistrationUpdateIndexesService {
    private static final Logger LOG = Logger.getLogger(MarriageRegistrationUpdateIndexesService.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private MarriageRegistrationIndexService marriageRegistrationIndexService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;

    public void updateIndexes(MarriageRegistration marriageRegistration) {
        User user = null;
        List<Object> asignList = null;
        if (marriageRegistration.getState() != null && marriageRegistration.getState().getOwnerPosition() != null) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(marriageRegistration.getState().getOwnerPosition().getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(marriageRegistration.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        String url = "/mrs/registration/viewapplication/" + marriageRegistration.getApplicationNo();
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(marriageRegistration.getApplicationNo());
        if (applicationIndex != null && null != marriageRegistration.getId()) {
            applicationIndex.setStatus(marriageRegistration.getStatus().getDescription());
            applicationIndex.setOwnerName(user != null ? user.getUsername() + "::" + user.getName() : "");
            if ("APPROVED".equals(marriageRegistration.getStatus().getCode())) {
                applicationIndex.setApproved(ApprovalStatus.APPROVED);
                applicationIndex.setClosed(ClosureStatus.YES);
            } else if (MarriageRegistration.RegistrationStatus.REJECTED.toString().equals(marriageRegistration.getStatus().getCode()) || MarriageRegistration.RegistrationStatus.CANCELLED.toString().equals(marriageRegistration.getStatus().getCode())) {
                applicationIndex.setApproved(ApprovalStatus.REJECTED);
                applicationIndex.setClosed(ClosureStatus.YES);
            }
            if (marriageRegistration.getApplicationNo() != null) {
                applicationIndex.setConsumerCode(marriageRegistration.getApplicationNo());
            }
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
            this.marriageRegistrationIndexService.createMarriageIndex(marriageRegistration, MarriageCertificateType.REGISTRATION.toString());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Application Index creation Started... ");
            }
            AppConfigValues marriageSla = this.marriageRegistrationService.getSlaAppConfigValuesForMarriageReg("Marriage Registration", "SLAFORMARRIAGEREGISTRATION");
            applicationIndex = ApplicationIndex.builder().withModuleName("Marriage Registration").withApplicationNumber(marriageRegistration.getApplicationNo()).withApplicationDate(marriageRegistration.getApplicationDate()).withApplicationType(MarriageCertificateType.REGISTRATION.toString()).withApplicantName(marriageRegistration.getHusband().getFullName() + "::" + marriageRegistration.getWife().getFullName()).withStatus(marriageRegistration.getStatus().getDescription()).withUrl(String.format(url, new Object[0])).withApplicantAddress(marriageRegistration.getHusband().getContactInfo().getResidenceAddress()).withOwnername(user != null ? user.getUsername() + "::" + user.getName() : "").withChannel(marriageRegistration.getSource() == null ? Source.SYSTEM.toString() : marriageRegistration.getSource()).withMobileNumber(marriageRegistration.getHusband().getContactInfo().getMobileNo()).withClosed(ClosureStatus.NO).withSla(Integer.valueOf(marriageSla != null && marriageSla.getValue() != null ? Integer.valueOf(marriageSla.getValue()) : 0)).withApproved(ApprovalStatus.INPROGRESS).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Application Index creation completed...");
            }
            this.marriageRegistrationIndexService.createMarriageIndex(marriageRegistration, MarriageCertificateType.REGISTRATION.toString());
        }
    }
}

