/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.masters.service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.mrs.domain.enums.MarriageFeeCriteriaType;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.repository.MarriageFeeRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageFeeService {
    @Autowired
    private MarriageFeeRepository marriageFeeRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void create(MarriageFee fee) {
        this.marriageFeeRepository.save((Object)fee);
    }

    @Transactional
    public MarriageFee update(MarriageFee fee) {
        return (MarriageFee)((Object)this.marriageFeeRepository.saveAndFlush((Object)fee));
    }

    public MarriageFee getFee(Long id) {
        return this.marriageFeeRepository.findById(id);
    }

    public List<MarriageFee> getAll() {
        return this.marriageFeeRepository.findAll();
    }

    public MarriageFee getFeeForDays(Long days) {
        return this.marriageFeeRepository.findByToDaysLessThanEqual(days);
    }

    public MarriageFee getFeeForDate(Date date) {
        Long daysAfterMarriage = ChronoUnit.DAYS.between(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), LocalDateTime.now());
        return this.getFeeForDays(daysAfterMarriage);
    }

    public MarriageFee getFeeForCriteria(String criteria) {
        return this.marriageFeeRepository.findByCriteria(criteria);
    }

    public List<MarriageFee> searchFee(MarriageFee fee) {
        Criteria criteria = this.buildSearchCriteria(fee);
        return criteria.list();
    }

    public AppConfigValues getDaysValidationAppConfValue(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }

    public List<MarriageFee> getActiveGeneralTypeFeeses() {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageFee.class);
        criteria.add((Criterion)Restrictions.eq((String)"feeType", (Object)((Object)MarriageFeeCriteriaType.GENERAL))).add((Criterion)Restrictions.eq((String)"active", (Object)Boolean.TRUE));
        return criteria.list();
    }

    public List<MarriageFee> searchRegistrationFeesWithGeneralType(MarriageFee fee) {
        Criteria criteria = this.buildSearchCriteria(fee);
        criteria.add((Criterion)Restrictions.eq((String)"feeType", (Object)((Object)MarriageFeeCriteriaType.GENERAL)));
        return criteria.list();
    }

    public Criteria buildSearchCriteria(MarriageFee fee) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageFee.class);
        if (null != fee.getCriteria()) {
            criteria.add(Restrictions.ilike((String)"criteria", (String)fee.getCriteria().trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }
}

