/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.masters.entity;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.mrs.domain.enums.MarriageFeeCriteriaType;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egmrs_fee")
@Unique(id="id", tableName="egmrs_fee", columnName={"criteria"}, fields={"criteria"}, enableDfltMsg=true, message="Already Exist.name should be unique.")
@SequenceGenerator(name="SEQ_EGMRS_FEE", sequenceName="SEQ_EGMRS_FEE", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class MarriageFee
extends AbstractAuditable {
    private static final long serialVersionUID = 4605301246092443240L;
    public static final String SEQ_FEE = "SEQ_EGMRS_FEE";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_FEE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    @Length(max=50)
    @Audited
    private String criteria;
    @NotNull
    @Audited
    private Double fees;
    @Enumerated(value=EnumType.ORDINAL)
    private MarriageFeeCriteriaType feeType;
    @Audited
    private Integer fromDays;
    @Audited
    private Integer toDays;
    private boolean active;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    public Double getFees() {
        return this.fees;
    }

    public void setFees(Double fees) {
        this.fees = fees;
    }

    public Integer getFromDays() {
        return this.fromDays;
    }

    public void setFromDays(Integer fromDays) {
        this.fromDays = fromDays;
    }

    public Integer getToDays() {
        return this.toDays;
    }

    public void setToDays(Integer toDays) {
        this.toDays = toDays;
    }

    public MarriageFeeCriteriaType getFeeType() {
        return this.feeType;
    }

    public void setFeeType(MarriageFeeCriteriaType feeType) {
        this.feeType = feeType;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        result = 31 * result + (this.fees == null ? 0 : this.fees.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MarriageFee other = (MarriageFee)((Object)obj);
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.criteria == null ? other.criteria != null : !this.criteria.equals(other.criteria)) {
            return false;
        }
        return !(this.fees == null ? other.fees != null : !this.fees.equals(other.fees));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

