/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.mrs.domain.entity.IdentityProof;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MrApplicant;
import org.egov.mrs.domain.entity.MrApplicantDocument;
import org.egov.mrs.domain.repository.MarriageApplicantRepository;
import org.egov.mrs.domain.service.ApplicantDocumentService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class MarriageApplicantService {
    private static final String ERROR_WHILE_PREPARING_THE_DOCUMENT_FOR_VIEW = "Error while preparing the document for view";
    private static final Logger LOG = Logger.getLogger(MarriageRegistrationService.class);
    private final MarriageApplicantRepository applicantRepository;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private ApplicantDocumentService applicantDocumentService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;

    @Autowired
    public MarriageApplicantService(MarriageApplicantRepository applicantRepository) {
        this.applicantRepository = applicantRepository;
    }

    @Transactional
    public void createApplicant(MrApplicant applicant) {
        this.applicantRepository.save((Object)applicant);
    }

    @Transactional
    public MrApplicant updateApplicant(MrApplicant applicant) {
        return (MrApplicant)((Object)this.applicantRepository.saveAndFlush((Object)applicant));
    }

    public MrApplicant getApplicant(Long id) {
        return this.applicantRepository.findById(id);
    }

    public void prepareDocumentsForView(MrApplicant applicant) {
        File file;
        if (applicant.getPhotoFileStore() != null) {
            file = this.fileStoreService.fetch(applicant.getPhotoFileStore().getFileStoreId(), "MRS");
            try {
                applicant.setEncodedPhoto(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
            }
            catch (IOException e) {
                LOG.error((Object)ERROR_WHILE_PREPARING_THE_DOCUMENT_FOR_VIEW, (Throwable)e);
            }
        }
        if (applicant.getSignatureFileStore() != null) {
            file = this.fileStoreService.fetch(applicant.getSignatureFileStore().getFileStoreId(), "MRS");
            try {
                applicant.setEncodedSignature(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
            }
            catch (IOException e) {
                LOG.error((Object)ERROR_WHILE_PREPARING_THE_DOCUMENT_FOR_VIEW, (Throwable)e);
            }
        }
        applicant.getApplicantDocuments().forEach(appDoc -> {
            try {
                if (appDoc.getFileStoreMapper() != null) {
                    File file = this.fileStoreService.fetch(appDoc.getFileStoreMapper().getFileStoreId(), "MRS");
                    appDoc.setBase64EncodedFile(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
                }
            }
            catch (IOException e) {
                LOG.error((Object)ERROR_WHILE_PREPARING_THE_DOCUMENT_FOR_VIEW, (Throwable)e);
            }
        });
    }

    public void deleteDocuments(MrApplicant applicantModel, MrApplicant applicant) {
        ArrayList<MrApplicantDocument> toDelete = new ArrayList<MrApplicantDocument>();
        HashMap documentIdAndApplicantDoc = new HashMap();
        applicant.getApplicantDocuments().forEach(appDoc -> documentIdAndApplicantDoc.put(appDoc.getDocument().getId(), appDoc));
        if (applicantModel.getDocuments() != null) {
            applicantModel.getDocuments().stream().filter(doc -> doc.getFile().getSize() > 0L).map(doc -> {
                MrApplicantDocument appDoc = (MrApplicantDocument)((Object)((Object)documentIdAndApplicantDoc.get(doc.getId())));
                if (appDoc != null) {
                    this.fileStoreService.delete(appDoc.getFileStoreMapper().getFileStoreId(), "MRS");
                }
                return appDoc;
            }).collect(Collectors.toList()).forEach(appDoc -> toDelete.add((MrApplicantDocument)((Object)appDoc)));
            this.applicantDocumentService.delete(toDelete);
        }
    }

    public void addDocumentsToFileStore(MrApplicant applicant, Map<Long, MarriageDocument> documentAndId) {
        List<MarriageDocument> documents = applicant.getDocuments();
        IdentityProof identityProof = applicant.getProofsAttached() != null ? applicant.getProofsAttached() : new IdentityProof();
        if (documents != null) {
            documents.stream().filter(document -> !document.getFile().isEmpty() && document.getFile().getSize() > 0L).map(document -> {
                MrApplicantDocument applicantDocument = new MrApplicantDocument();
                this.setApplicantDocumentsFalg(applicant, (MarriageDocument)((Object)document), identityProof);
                applicantDocument.setApplicant(applicant);
                applicantDocument.setDocument((MarriageDocument)((Object)((Object)documentAndId.get(document.getId()))));
                applicantDocument.setFileStoreMapper(this.addToFileStore(document.getFile()));
                return applicantDocument;
            }).collect(Collectors.toList()).forEach(doc -> applicant.addApplicantDocument((MrApplicantDocument)((Object)doc)));
        }
        applicant.setProofsAttached(identityProof);
    }

    public void setApplicantDocumentsFalg(MrApplicant mrApplicant, MarriageDocument document, IdentityProof identityProof) {
        MarriageDocument marriageDocument = this.marriageDocumentService.get(document.getId());
        if (marriageDocument.getCode().equals("Passport")) {
            identityProof.setPassport(true);
        }
        if (marriageDocument.getCode().equals("RationCard")) {
            identityProof.setRationCard(true);
        }
        if (marriageDocument.getCode().equals("Aadhar")) {
            identityProof.setAadhar(true);
        }
        if (marriageDocument.getCode().equals("SLC")) {
            identityProof.setSchoolLeavingCertificate(true);
        }
        if (marriageDocument.getCode().equals("TelephoneBill")) {
            identityProof.setTelephoneBill(true);
        }
        if (marriageDocument.getCode().equals("BC")) {
            identityProof.setBirthCertificate(true);
        }
        if (marriageDocument.getCode().equals("DCSWA")) {
            identityProof.setDeaceasedDeathCertificate(true);
        }
        if (marriageDocument.getCode().equals("DCA")) {
            identityProof.setDivorceCertificate(true);
        }
        if (mrApplicant.getPhotoFile() != null && mrApplicant.getPhotoFile().getSize() != 0L) {
            identityProof.setPhotograph(true);
        }
    }

    private FileStoreMapper addToFileStore(MultipartFile file) {
        FileStoreMapper fileStoreMapper = null;
        try {
            fileStoreMapper = this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "MRS");
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
        }
        return fileStoreMapper;
    }
}

