/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egmrs_certificate")
@SequenceGenerator(name="SEQ_EGMRS_CERTIFICATE", sequenceName="SEQ_EGMRS_CERTIFICATE", allocationSize=1)
public class MarriageCertificate
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_MARRIAGECERTIFICATE = "SEQ_EGMRS_CERTIFICATE";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_CERTIFICATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    private String certificateNo;
    private Date certificateDate;
    @Enumerated(value=EnumType.STRING)
    private MarriageCertificateType certificateType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="registration")
    private MarriageRegistration registration;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="filestore", nullable=false)
    private FileStoreMapper fileStore;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="reissue")
    private ReIssue reIssue;
    private boolean certificateIssued;
    @Transient
    private Date fromDate;
    @Transient
    private Date toDate;
    @Transient
    private String frequency;
    @Transient
    private int printCertificateResrictionDays;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCertificateNo() {
        return this.certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    public Date getCertificateDate() {
        return this.certificateDate;
    }

    public void setCertificateDate(Date certificateDate) {
        this.certificateDate = certificateDate;
    }

    public MarriageCertificateType getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(MarriageCertificateType certificateType) {
        this.certificateType = certificateType;
    }

    public MarriageRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(MarriageRegistration registration) {
        this.registration = registration;
    }

    public FileStoreMapper getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStoreMapper fileStore) {
        this.fileStore = fileStore;
    }

    public ReIssue getReIssue() {
        return this.reIssue;
    }

    public void setReIssue(ReIssue reIssue) {
        this.reIssue = reIssue;
    }

    public boolean isCertificateIssued() {
        return this.certificateIssued;
    }

    public void setCertificateIssued(boolean certificateIssued) {
        this.certificateIssued = certificateIssued;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public int getPrintCertificateResrictionDays() {
        return this.printCertificateResrictionDays;
    }

    public void setPrintCertificateResrictionDays(int printCertificateResrictionDays) {
        this.printCertificateResrictionDays = printCertificateResrictionDays;
    }
}

