<!-- #-------------------------------------------------------------------------------
# eGov suite of products aim to improve the internal efficiency,transparency, 
#    accountability and the service delivery of the government  organizations.
# 
#     Copyright (C) <2015>  eGovernments Foundation
# 
#     The updated version of eGov suite of products as by eGovernments Foundation 
#     is available at http://www.egovernments.org
# 
#     This program is free software: you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program. If not, see http://www.gnu.org/licenses/ or 
#     http://www.gnu.org/licenses/gpl.html .
# 
#     In addition to the terms of the GPL license to be adhered to in using this
#     program, the following additional terms are to be complied with:
# 
# 	1) All versions of this program, verbatim or modified must carry this 
# 	   Legal Notice.
# 
# 	2) Any misrepresentation of the origin of the material is prohibited. It 
# 	   is required that all modified versions of this material be marked in 
# 	   reasonable ways as different from the original version.
# 
# 	3) This license does not grant any rights to any user of the program 
# 	   with regards to rights under trademark law for use of the trade names 
# 	   or trademarks of eGovernments Foundation.
# 
#   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
#------------------------------------------------------------------------------- -->
<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>

<div class="row" id="page-content">
	<div class="col-md-12">
		<form:form mothod="post" class="form-horizontal form-groups-bordered"
			modelAttribute="transactionRequest" id="updateApplicantDetails">
			<div class="panel panel-primary" data-collapsed="0">
				<div class="panel-heading">
					<div class="panel-title dynamic-span capitalize"
						style="text-align: center;">
						<span><label><c:out
									value="${transactionRequest.serviceId.name}"></c:out></label></span>
					</div>
				</div>
				<div class="panel-body">
					<div class="form-group">
						<label class="col-sm-3 control-label"><spring:message
								code="lbl.applicantName" /><span class="mandatory"></span></label>
						<div class="col-sm-6">
							<form:input path="paymentDetails.applicantName" id="name"
								type="text" placeholder="Applicant Name"
								class="form-control patternvalidation"
								data-pattern="alphabetwithspace" required="required" />
							<form:errors path="paymentDetails.applicantName"
								cssClass="add-margin error-msg" />
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><spring:message
								code="lbl.mobileNo" /><span class="mandatory"></span></label>
						<div class="col-sm-6">
							<form:input path="paymentDetails.mobileNo"
								cssClass="form-control is_valid_number" id="is_valid_number"
								placeholder="Mobile number" title="Enter valid mobile number!"
								minlength="10" maxlength="10" autocomplete="off"
								required="required" />
							<form:errors path="paymentDetails.mobileNo"
								cssClass="add-margin error-msg" />
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><spring:message
								code="lbl.deliveryType" /><span class="mandatory"></span></label>
						<div class="col-sm-6">
							<form:radiobutton path="paymentDetails.deliveryType"
								value="LOCAL" id="Local" />
							Local
							<form:radiobutton path="paymentDetails.deliveryType"
								value="NONLOCAL" id="NonLocal" />
							Non Local
							<form:radiobutton id="Manual" checked="checked"
								path="paymentDetails.deliveryType" value="MANUAL" />
							Manual
							<form:errors path="paymentDetails.deliveryType"
								cssClass="add-margin error-msg" />
							<div class="error-msg">
								<spring:message code="lbl.deliveryTypeMsg" />
							</div>
						</div>

					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><spring:message
								code="lbl.applicantAddress" /><span class="mandatory"></span></label>
						<div class="col-sm-6">
							<form:textarea path="paymentDetails.applicantAddress"
								required="required" class="form-control"
								placeholder="Applicant Address" />
							<form:errors path="paymentDetails.applicantAddress"
								cssClass="add-margin error-msg" />
						</div>
					</div>

				</div>
			</div>



			<div class="panel panel-primary" data-collapsed="0">
				<div class="panel-heading">
					<div class="panel-title" style="text-align: center;">
						<label><spring:message code="lbl.feeChargesDetails" /></label>
					</div>
				</div>
				<div class="panel-body">

					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-6">
							<table class="table table-bordered" style="margin-bottom: 0px;">
								<tbody>
									<c:if test="${not empty charges}">

										<c:forEach var="charge" items="${charges}">
											<tr id="${charge.type}">
												<td class="col-sm-10"><c:if
														test="${charge.type =='SERVICEAMOUNT'}">
														<spring:message code="lbl.ServiceAmount" />
													</c:if> <c:if test="${charge.type =='USERCHARGES'}">
														<spring:message code="lbl.UserCharges" />
													</c:if> <c:if test="${charge.type =='POSTALCHARGES-LOCAL'}">
														<spring:message code="lbl.PostalCharges" />
													</c:if> <c:if test="${charge.type =='POSTALCHARGES-NONLOCAL'}">
														<spring:message code="lbl.PostalCharges" />
													</c:if> <c:if test="${charge.type =='CHALLANAMOUNT'}">
														<spring:message code="lbl.ChallanAmount" />
													</c:if> <c:if test="${charge.type =='PRINTCHARGES'}">
														<spring:message code="lbl.PrintCharges" />
													</c:if></td>
												<td class="text-right format-number"><c:out
														value="${charge.value}"></c:out></td>
												<input type="hidden" id="${charge.type}AMOUNT"
													value="${charge.value}">
											</tr>
										</c:forEach>
										<input type="hidden" id="tempTotalAmount"
											value="${totalAmount}">
										<tr id="${charge.type}">
											<td class="view-content"><spring:message
													code="lbl.totalAmount" /></td>
											<td id="totalAmount"
												class="view-content format-number text-right"><c:out
													value="${totalAmount}"></c:out></td>
										</tr>
									</c:if>
								</tbody>
							</table>
						</div>
					</div>


				</div>
			</div>
			<div class="row">
				<div class="text-center">
					<button type="button" class="btn btn-primary" id="confirmmsg">
						<spring:message code="lbl.proceed" />
					</button>
				</div>
			</div>
		</form:form>
	</div>
</div>
<script type="text/javascript">
	window.location.hash = "no-back-button";
	window.location.hash = "Again-No-back-button";//again because google chrome don't insert first hash into history
	window.onhashchange = function() {
		window.location.hash = "no-back-button";
	}
	function disableRefresh(e) {
		if ((e.which || e.keyCode) == 116)
			e.preventDefault();
		if (e.ctrlKey)
			if ((e.which || e.keyCode) == 82)
				e.preventDefault();
	};
	$(document).on("keydown", disableRefresh);
	$(document)
			.ready(
					function($) {
						$('#POSTALCHARGES-LOCAL').addClass('display-hide');
						$('#POSTALCHARGES-NONLOCAL').addClass('display-hide');
						$('#Local')
								.change(
										function() {

											$('#POSTALCHARGES-LOCAL')
													.removeClass('display-hide');
											$('#POSTALCHARGES-NONLOCAL')
													.addClass('display-hide');
											var tempAmount = $(
													'#tempTotalAmount').val();
											var localAmount = $(
													'#POSTALCHARGES-LOCALAMOUNT')
													.val();
											$('#totalAmount')
													.html(
															parseFloat(tempAmount)
																	+ parseFloat(localAmount));
											formatNumberColumns();
										});
						$('#NonLocal')
								.change(
										function() {
											$('#POSTALCHARGES-LOCAL').addClass(
													'display-hide');
											$('#POSTALCHARGES-NONLOCAL')
													.removeClass('display-hide');
											var tempAmount = $(
													'#tempTotalAmount').val();
											var nonLocalAmount = $(
													'#POSTALCHARGES-NONLOCALAMOUNT')
													.val();
											$('#totalAmount')
													.html(
															(parseFloat(tempAmount) + parseFloat(nonLocalAmount)));
											formatNumberColumns();
										});
						$('#Manual').change(
								function() {
									$('#totalAmount').html(
											$('#tempTotalAmount').val());
									$('#POSTALCHARGES-LOCAL').addClass(
											'display-hide');
									$('#POSTALCHARGES-NONLOCAL').addClass(
											'display-hide');
									formatNumberColumns();
								});
						$('#confirmmsg')
								.click(
										function(e) {
											if ($('#updateApplicantDetails')
													.valid()) {
												if (confirm(<spring:message code="lbl.confirmMsg" />)) {
													document
															.getElementById(
																	"updateApplicantDetails")
															.submit();
													$('.loader-class')
															.modal(
																	'show',
																	{
																		backdrop : 'static'
																	});
												} else {
													e.preventDefault();
													window.close();
												}

												formatNumberColumns();

											}

										});

						function formatNumberColumns() {
							$('.format-number')
									.each(
											function() {

												$(this)
														.html(
																parseFloat(
																		$(this)
																				.html())
																		.toFixed(
																				2)
																		.replace(
																				/(\d)(?=(\d\d)+\d$)/g,
																				"$1,"));

											});
						}

						formatNumberColumns();

					});
</script>