/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.web.controller;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.masters.entity.Charges;
import org.egov.meeseva.masters.service.ChargesService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value = "/updateApplicantDetails/{transactionRequestId}")
public class UpdateApplicantDetailsController {
    @Autowired
    private TransactionRequestService transactionRequestService;

    @Autowired
    private ChargesService chargesService;

    @ModelAttribute("transactionRequest")
    public TransactionRequest transactionRequestModel(@PathVariable final Long transactionRequestId) {
        return transactionRequestService.getRequestById(transactionRequestId);
    }

    @RequestMapping(method = RequestMethod.GET)
    public String newForm(@PathVariable final Long transactionRequestId, final Model model) {

        final TransactionRequest request = transactionRequestService.getRequestById(transactionRequestId);
        if (!validRequest(request))
            throw new ApplicationRuntimeException("MEESEVA.003");
        final List<Charges> charges = chargesService.getListOfChargesByServiceId(request.getServiceId().getId());
        Double totalAmount = 0.0d;
        for (final Charges charge : charges)
            if (!(charge.getType().equalsIgnoreCase(MeesevaConstants.POSTALCHARGES_LOCAL) || charge.getType().equals(
                    MeesevaConstants.POSTALCHARGES_NONLOCAL)))
                totalAmount = totalAmount.doubleValue() + charge.getValue().doubleValue();

        model.addAttribute("charges", charges);
        model.addAttribute("totalAmount", totalAmount);

        return "updateApplicantDetails-form";
    }

    @RequestMapping(method = RequestMethod.POST)
    public RedirectView redirect(@ModelAttribute TransactionRequest transactionRequest, final BindingResult errors,
            final RedirectAttributes redirectAttrs, final HttpServletRequest request) {
        if (!validRequest(transactionRequest))
            throw new ApplicationRuntimeException("MEESEVA.003");
        RedirectView redirect = null;
        if (transactionRequest.getServiceId().getUrl().contains("?"))
            redirect = new RedirectView(transactionRequest.getServiceId().getUrl()
                    + "&applicationNo=" +
                    transactionRequest.getApplicationNo() + "&meesevaServicecode=" + transactionRequest.getServiceId().getCode(),
                    false);
        else
            redirect = new RedirectView(transactionRequest.getServiceId().getUrl()
                    + "?applicationNo=" +
                    transactionRequest.getApplicationNo() + "&meesevaServicecode=" + transactionRequest.getServiceId().getCode(),
                    false);
        final FlashMap outputFlashMap = RequestContextUtils
                .getOutputFlashMap(request);
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("applicationNo", transactionRequest.getApplicationNo());
        params.put("meesevaServicecode", transactionRequest.getServiceId().getCode());
        if (outputFlashMap != null) {
            outputFlashMap.put("url", request.getRequestURL());
            outputFlashMap.put("params", params);
        }
        transactionRequest = transactionRequestService.updateChargesByServiceAndDeliveryType(transactionRequest
                .getPaymentDetails().getDeliveryType(), transactionRequest);
        transactionRequest.getPaymentDetails().setApplicantDetailsUpdated(true);
        transactionRequest.getPaymentDetails().setApplicantAddress(
                transactionRequest.getPaymentDetails().getApplicantAddress().replaceAll("[\\t\\n\\r]+", " "));
        transactionRequestService.update(transactionRequest);
        return redirect;
    }

    private boolean validRequest(final TransactionRequest transactionRequest) {
        final TransactionRequest request = transactionRequestService.getRequestById(transactionRequest.getId());
        if (request.getPaymentDetails().isApplicantDetailsUpdated())
            return false;
        else
            return true;

    }
}
