/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.web.controller;

import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.transactions.entity.CollectMutationCharge;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.PaymentDetailsService;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping(value = "/payMutationCharge/{transactionRequestId}")
public class PayMutationChargeController {
	@Autowired
	private TransactionRequestService transactionRequestService;
	@Autowired
	private PropertyExternalService propertyExternalService;
	@Autowired
	private MeeSevaWebService meeSevaWebService;

	@Autowired
	PaymentDetailsService paymentDetailsService;

	private String COLLECTIONURL = "/collection/citizen/onlineReceipt-viewReceipt.action?receiptNumber=";

	private static final Logger LOGGER = Logger
			.getLogger(PayMutationChargeController.class);

	@RequestMapping(method = RequestMethod.GET)
	public String newForm(@PathVariable final Long transactionRequestId,
			final Model model) {

    	
		final TransactionRequest request = transactionRequestService
				.getRequestById(transactionRequestId);
		if (!validRequest(request))
			throw new ApplicationRuntimeException("MEESEVA.003");

		if (request != null) {
			CollectMutationCharge collectMutationCharge = new CollectMutationCharge();
			collectMutationCharge.setPropertyNumber(request.getPaymentDetails()
					.getTransactionServiceNumber());
			collectMutationCharge.setServiceId(request.getServiceId().getId());
			collectMutationCharge.setServiceName(request.getServiceId()
					.getName());
			collectMutationCharge.setTransactionRequestId(request.getId());

			model.addAttribute("collectMutationCharge", collectMutationCharge);
		}
		return "payMutationCharge-form";
	}

    @RequestMapping(method = RequestMethod.POST)
    public RedirectView redirect(@ModelAttribute CollectMutationCharge collectMutationCharge, final BindingResult errors,
            final RedirectAttributes redirectAttrs, final HttpServletRequest request) {
    	RedirectView redirect =null;
    	
    	if(collectMutationCharge!=null && collectMutationCharge.getTransactionRequestId()!=null)
    	{
    		
    	final TransactionRequest transactionRequest = transactionRequestService
				.getRequestById(collectMutationCharge.getTransactionRequestId()); 
    	
       if(transactionRequest!=null) {
    	if (!validApplicationNumber(collectMutationCharge.getApplicationNumber()))
    		throw new ApplicationRuntimeException("MEESEVA.005");
    	
    	TransactionRequest earlierTransactionRequest=transactionRequestService.getRequestByMeesevaApplicationNo(collectMutationCharge.getApplicationNumber());
    	  
    	transactionRequest.getPaymentDetails().setTransactionServiceNumber(collectMutationCharge.getPropertyNumber());
    	transactionRequest.getPaymentDetails().setServiceAmount(collectMutationCharge.getAmount().doubleValue());
    	transactionRequest.getPaymentDetails().setTotalAmount(collectMutationCharge.getAmount().doubleValue());
        transactionRequest.getPaymentDetails().setApplicantDetailsUpdated(true);
        transactionRequest.getPaymentDetails().setApplicantAddress("Mutation Charge payment from meeseva");
        transactionRequest.getPaymentDetails().setApplicantName(earlierTransactionRequest.getPaymentDetails().getApplicantName());//TODO: CHECK THIS
         transactionRequestService.update(transactionRequest);
         
    	
         final boolean paymentGateWayResponse = meeSevaWebService.GetPaymentGatewayResponse(transactionRequest);

				if (!paymentGateWayResponse)
					throw new ApplicationRuntimeException("MEESEVA.004");
				if (LOGGER.isDebugEnabled())
					LOGGER.info("paymentGateWayResponse "+ paymentGateWayResponse);

				transactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
				transactionRequestService.update(transactionRequest);

				ReceiptDetails receiptDetails = payMutationCharge(collectMutationCharge, transactionRequest);

				redirect = buildUrlRedirect(collectMutationCharge,receiptDetails);

				// 2ND meeseva webservice call
				final String updatePaymentTransaction = meeSevaWebService
						.getPaymentTransId(transactionRequest);

				// transactionRequest.getPaymentDetails().setTransactionServiceId(basicProperty.getId());
				// //TODO: WE NEED TO SET THIS ID.

				transactionRequestService.buildTransactionRequestOnPaymentUpdate(transactionRequest, updatePaymentTransaction);

		        transactionRequest.getPaymentDetails().setTransactionServiceNumber(collectMutationCharge.getApplicationNumber());
		        transactionRequest.getPaymentDetails().setReceiptNumber(receiptDetails.getReceiptNo());
		        
        //THIRD meeseva webservice call
        final boolean updateStatus = meeSevaWebService.UpdateApplicationDetails(transactionRequest,"NA", MeesevaConstants.MEESEVA_STATUS_APPROVED,"NA");
				if (updateStatus) {
					transactionRequest.setTransactionStatus(MeesevaConstants.MEESEVA_STATUS_APPROVED);
					transactionRequest.setStatusUpdateRemarks("");
					transactionRequest.setStatusUpdated(true);
					transactionRequest.setHistory(true);
				}
         transactionRequestService.update(transactionRequest);
    	}else{
    		 throw new ApplicationRuntimeException("MEESEVA.003");
    		}
      	}    	

        if(redirect==null)
        	throw new ApplicationRuntimeException("MEESEVA.003");
    	return redirect;
    }

	private ReceiptDetails payMutationCharge(CollectMutationCharge collectMutationCharge,final TransactionRequest transactionRequest) {
		PayPropertyTaxDetails payPropTaxDetails = new PayPropertyTaxDetails();
    	payPropTaxDetails.setApplicationNo(collectMutationCharge.getApplicationNumber());
    	payPropTaxDetails.setAssessmentNo(collectMutationCharge.getPropertyNumber());
    	payPropTaxDetails.setPaymentAmount(collectMutationCharge.getAmount());
    	payPropTaxDetails.setSource(MeesevaConstants.MODULE_NAME);
    	payPropTaxDetails.setUlbCode(transactionRequest.getPaymentDetails().getMunicipalCode());
    	payPropTaxDetails.setPaymentMode("cash");
    	payPropTaxDetails.setTransactionId(transactionRequest.getMeesevaRequestNo());//TODO: CHECK THIS logic.
    	 ReceiptDetails receiptDetails = propertyExternalService.payMutationFee(payPropTaxDetails);
		return receiptDetails;
	}

	private RedirectView buildUrlRedirect(
			CollectMutationCharge collectMutationCharge,
			ReceiptDetails receiptDetails) {
		RedirectView redirect=null;
		
		redirect =new RedirectView(COLLECTIONURL+receiptDetails.getReceiptNo() +"&consumerCode="+collectMutationCharge.getApplicationNumber() + "&serviceCode=PTMF" );
		return redirect;
	}

	private boolean validApplicationNumber(final String applcationNumber) {
	
		//Check Valid application number ?
		if (applcationNumber != null) {
			final TransactionRequest request = transactionRequestService.getRequestByMeesevaApplicationNo(applcationNumber);
			if (request==null)
				return false;
			else
			{
				PaymentDetails paymentDetail=paymentDetailsService.checkApplicationNumberAlreadyUsedInEarlierTransaction(applcationNumber,MeesevaConstants.SERVICE_TYPE_PAYMUTATIONFEE);
				if(paymentDetail==null) return true;
				if(paymentDetail!=null && paymentDetail.getReceiptNumber()!=null) return false;
			}
			
		}
		return true;
	}
	private boolean validRequest(final TransactionRequest transactionRequest) {
        final TransactionRequest request = transactionRequestService.getRequestById(transactionRequest.getId());
        if (request.getPaymentDetails().isApplicantDetailsUpdated())
            return false;
        else
            return true;

    }
	
}
