/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.web.controller;

import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.ptis.domain.service.property.PropertyThirdPartyService;
import org.egov.wtms.integration.WaterChargesThirdPartyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
public class MeeSevaServicesRedirectController {
    public static final String UPDATEAPPLICANTDETAILS_FORM = "/updateApplicantDetails";
    public static final String PAY_MUTATION_CHARGE_FORM = "/payMutationCharge";
    public static final String RECEIPT = "meeseva_receipt";
    public static final String GENERATE_RECEIPT = "/generatereceipt";
    public static final String PRINT_SERVICE_NOTICE_PDF = "/print-servicenotice-pdf";
    private String COLLECTIONURL = "/collection/citizen/onlineReceipt-viewReceipt.action?receiptNumber=";
	private String APPLICATIONNUMBER = "applicationNumber";
	private static final Logger LOGGER = Logger
			.getLogger(MeeSevaServicesRedirectController.class);
    @Autowired
    @Qualifier("messageSource")
    private MessageSource messageSource;

    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private CheckSumService checkSumService;

    @Autowired
    private ReportService reportService;

    @Autowired
    private PropertyThirdPartyService propertyThirdPartyService;

    @Autowired
    private WaterChargesThirdPartyService waterChargesThirdPartyService;

    private final Map<String, Object> reportParams = new HashMap<String, Object>();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;

    @RequestMapping(value = "/meesevaservices-redirect", method = RequestMethod.GET)
    public RedirectView redirectMeeSevaServices(final HttpServletRequest request) {
        TransactionRequest meesevaRequest = null;
        HashMap<String, String> requestParms = new HashMap<String, String>();

        // if it is for service request then validate decrypt parameters and validate service request
        if (request.getParameter("enc") != null) {
            requestParms = checkSumService.decryptInitialServiceRequestParameters(request);
            if (!genericMeesevaService.validateMeesevaServiceId(requestParms.get("serviceId")))
                throw new ApplicationRuntimeException("MEESEVA.001");
            if (genericMeesevaService.validateServiceRequest(requestParms.get("meesevaSequenceNumber"))) {
                meesevaRequest = genericMeesevaService.persistMeesevaRequest(request, requestParms);
                 RedirectView redirect = null;
                if(meesevaRequest!=null && meesevaRequest.getServiceId().getCode().equalsIgnoreCase(MeesevaConstants.SERVICE_TYPE_PAYMUTATIONFEE))
                	redirect= new RedirectView(PAY_MUTATION_CHARGE_FORM + "/" + meesevaRequest.getId(), true);
                else
                	 redirect= new RedirectView(UPDATEAPPLICANTDETAILS_FORM + "/" + meesevaRequest.getId(), true);
                final FlashMap outputFlashMap = RequestContextUtils
                        .getOutputFlashMap(request);
                if (outputFlashMap != null)
                    outputFlashMap.put("url", request.getRequestURL());
                return redirect;
            } else
                throw new ApplicationRuntimeException("MEESEVA.002");
        } else if (request.getParameter("applicationNo") != null) {
         
        	final TransactionRequest ts = transactionRequestService
                    .getRequestByMeesevaApplicationNo(request.getParameter("applicationNo"));
       
            if (ts != null) {
            	
				/*
				 * Check whether application number is same as the number which
				 * is in encrypted format. If application number not matching,
				 * then throw error.
				 */
            	requestParms = checkSumService.decryptPrintCertificateParameters(request);
				if (requestParms != null
						&& (requestParms.get(APPLICATIONNUMBER) != null && !request
								.getParameter("applicationNo").equalsIgnoreCase(requestParms.get(APPLICATIONNUMBER)))) {
					throw new ApplicationRuntimeException("MEESEVA.003");
				}  
             	
                 RedirectView redirect=null;
                
                 if(ts!=null && ts.getServiceId().getCode().equalsIgnoreCase(MeesevaConstants.SERVICE_TYPE_PAYMUTATIONFEE))
                 {
                  redirect =new RedirectView(COLLECTIONURL+ts.getPaymentDetails().getReceiptNumber() 
                		  +"&consumerCode="+ts.getPaymentDetails().getTransactionServiceNumber()+ "&serviceCode=PTMF" );
                			 
                 }else{
                redirect = new RedirectView(
                        PRINT_SERVICE_NOTICE_PDF + "?transactionServiceNumber="
                                + ts.getPaymentDetails().getTransactionServiceNumber() + "&applicationNo="
                                + request.getParameter("applicationNo") + "&serviceType=" + ts.getServiceId().getCode(),
                        true);
                 }
                final FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap(request);
                if (outputFlashMap != null)
                    outputFlashMap.put("url", request.getRequestURL());
                return redirect;
            } else
                throw new ApplicationRuntimeException("MEESEVA.003");
        } else
            throw new ApplicationRuntimeException("MEESEVA.003");

    }

    private ResponseEntity<byte[]> generateReport(final TransactionRequest transactionRequest, final HttpServletRequest request,
            final HttpSession session) {
    	
    	LOGGER.info("--- Inside generateReport() ----");
        reportInput = null;
        if (transactionRequest != null && transactionRequest.getPaymentDetails().getReceiptNumber() != null) {
        	LOGGER.info("---  transactionRequest receipt number ----" + transactionRequest.getPaymentDetails().getReceiptNumber() );
            final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            final String serviceName = transactionRequest.getServiceId().getName();
            reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
            final String url = WebUtils.extractRequestDomainURL(request, false);
            reportParams.put("cityLogo", url.concat(ReportConstants.IMAGE_CONTEXT_PATH)
                    .concat((String) request.getSession().getAttribute("citylogo")));
            reportParams.put("serviceName", serviceName);
            reportParams.put("applicantAddress", transactionRequest.getPaymentDetails().getApplicantAddress());
            reportParams.put("receiptNum", transactionRequest.getPaymentDetails().getReceiptNumber());
            reportParams.put("receiptDate", formatter.format(transactionRequest.getPaymentDetails().getReceiptDate()));
            reportParams.put("applicantName", transactionRequest.getPaymentDetails().getApplicantName());
            reportParams.put("applicationNumber", transactionRequest.getApplicationNo());
            reportParams.put("receiptDescription", serviceName);
            reportParams.put("meesevaTransactionID", transactionRequest.getMeesevaTransactionId());
            reportParams.put("scaUserID", transactionRequest.getScaUserId());
            reportParams.put("sla", transactionRequest.getServiceId().getSla());
            LOGGER.info("---  before calling ReportRequest ----" );
            reportInput = new ReportRequest(RECEIPT, getChargesList(transactionRequest), reportParams);
            LOGGER.info("---  after calling ReportRequest ----" );
        }
        final HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType("application/pdf"));
        headers.add("content-disposition", "inline;filename=Receipt.pdf");
        LOGGER.info("---  before calling createReport ----" );
        reportOutput = reportService.createReport(reportInput);
        LOGGER.info("---  after calling createReport ----" +reportOutput.getReportOutputData());
        return new ResponseEntity<byte[]>(reportOutput.getReportOutputData(), headers, HttpStatus.OK);
    }

    private List<Map<String, Object>> getChargesList(final TransactionRequest transactionRequest) {
        final List<Map<String, Object>> chargesList = new ArrayList<Map<String, Object>>();
        Map<String, Object> chargesMap = new HashMap<String, Object>();
        String DESCRIPTION = "description";
        String AMOUNT = "amount";
        
        chargesMap.put(DESCRIPTION, "User Charges");
        if (transactionRequest.getPaymentDetails().getUserCharges() != null)
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getUserCharges());
        else
            chargesMap.put(AMOUNT, 0);
        chargesList.add(chargesMap);
        
        chargesMap = new HashMap<String, Object>();
        chargesMap.put(DESCRIPTION, "Service Amount");

        if (transactionRequest.getPaymentDetails().getServiceAmount() != null)
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getServiceAmount());
        else
            chargesMap.put(AMOUNT, 0);
        chargesList.add(chargesMap);
        chargesMap = new HashMap<String, Object>();
        chargesMap.put(DESCRIPTION, "Print Charges");
        if (transactionRequest.getPaymentDetails().getPrintCharges() != null)
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getPrintCharges());
        else
            chargesMap.put(AMOUNT, 0);
        chargesList.add(chargesMap);
        chargesMap = new HashMap<String, Object>();
        chargesMap.put(DESCRIPTION, "Postal Charges");
        if (transactionRequest.getPaymentDetails().getPostalCharges() != null)
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getPostalCharges());
        else
            chargesMap.put(AMOUNT, 0);
        chargesList.add(chargesMap);
        chargesMap = new HashMap<String, Object>();
        chargesMap.put(DESCRIPTION, "Challan Amount");
        if (transactionRequest.getPaymentDetails().getChallanAmount() != null)
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getChallanAmount());
        else
            chargesMap.put(AMOUNT, 0);
        chargesList.add(chargesMap);
        return chargesList;
    }

    @RequestMapping(value = GENERATE_RECEIPT, method = RequestMethod.GET)
    public @ResponseBody ResponseEntity<byte[]> viewReport(@RequestParam final String transactionServiceNumber,
            final HttpServletRequest request, final HttpSession session) {
    	
    	LOGGER.info("--- Inside GENERATE_RECEIPT  ----");
    	
        final TransactionRequest transactionRequest = transactionRequestService
                .getRequestByTransactionServiceNumber(transactionServiceNumber);
        LOGGER.info("--- Before calling generateReport()  ----");
    	
        return generateReport(transactionRequest, request, session);
    }

    @RequestMapping(value = PRINT_SERVICE_NOTICE_PDF, method = RequestMethod.GET)
    private ResponseEntity<byte[]> printServiceNoticePDF(@RequestParam final String transactionServiceNumber,
            @RequestParam final String applicationNo, @RequestParam final String serviceType) throws IOException {
    	LOGGER.info("--- Inside PRINT_SERVICE_NOTICE_PDF  ----");
        byte[] pdfOutputStream = null;
        if (serviceType.contains(MeesevaConstants.PROPERTYTAXSERVICECODEPREFIX))
            pdfOutputStream = propertyThirdPartyService.getSpecialNotice(null, transactionServiceNumber,
                    MeesevaConstants.SERVICE_TYPE_APPLICATION_TYPE_MAP.get(serviceType));
        else if (serviceType.contains(MeesevaConstants.WATERTAXSERVICECODEPREFIX))
            pdfOutputStream = waterChargesThirdPartyService.getEstimationNotice(transactionServiceNumber);

        if (pdfOutputStream == null)
            return redirectToErrorPage(
                    messageSource.getMessage("err.validate.service.notices.null", new String[] { applicationNo }, null));
        final HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType("application/pdf"));
        headers.add("content-disposition", "inline;filename=ServiceNotice.pdf");
        LOGGER.info("--- finished PRINT_SERVICE_NOTICE_PDF  ----");
        return new ResponseEntity<byte[]>(pdfOutputStream, headers, HttpStatus.CREATED);
    }

    private ResponseEntity<byte[]> redirectToErrorPage(String errorMessage) {
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage
                + "</p></body></html>";
        final byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity<byte[]>(byteData, HttpStatus.CREATED);
    }

}
