DROP TABLE egmeeseva_services cascade;

DROP TABLE egmeeseva_charges cascade;

DROP TABLE egmeeseva_transactionRequest cascade;

DROP TABLE egmeeseva_transactionResponse cascade;

DROP SEQUENCE seq_egmeeseva_services;

DROP SEQUENCE seq_egmeeseva_charges;

DROP SEQUENCE seq_egmeeseva_transactionRequest;

DROP SEQUENCE seq_egmeeseva_transactionResponse;


CREATE TABLE egmeeseva_services (
    id bigint NOT NULL,
    meesevaserviceid character varying(50),
    name character varying(250),
    code character varying(50),
    category character varying(250),
    sla smallint,
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_services
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY egmeeseva_services
    ADD CONSTRAINT pk_egmeeseva_services PRIMARY KEY (id);


CREATE TABLE egmeeseva_charges (
    id bigint NOT NULL,
    serviceId bigint NOT NULL,
    type character varying(50),
    calculationtype character varying(50),
    value double precision, 
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_charges
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY egmeeseva_charges
    ADD CONSTRAINT pk_egmeeseva_charges PRIMARY KEY (id);
ALTER TABLE ONLY egmeeseva_charges
    ADD CONSTRAINT fk_service_charges FOREIGN KEY (serviceId) REFERENCES egmeeseva_services(id);

CREATE TABLE egmeeseva_transactionRequest (
    id bigint NOT NULL,
    serviceId bigint,
    applicationNo character varying(50),
    meesevaRequestNo character varying(50),
    uniqueNo character varying(50),
    scaUserId character varying(50),
    channelId character varying(50),
    requestId character varying(50),
    operaterId character varying(50),
    scaPassword character varying(50),
    organizationflag character varying(50),
    paymentConfirmStatus boolean,
    meesevaTransactionId character varying(50),
    paymentUpdated boolean,
    transactionStatus character varying(10),
    statusUpdated boolean,
    statusUpdateRemarks character varying(250),
    isHistory boolean default false,
    createddate timestamp without time zone,
    lastmodifieddate timestamp without time zone,
    createdby bigint,
    lastmodifiedby bigint,
    version bigint
);
CREATE SEQUENCE seq_egmeeseva_transactionRequest
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE ONLY egmeeseva_transactionRequest
    ADD CONSTRAINT pk_transactionRequest PRIMARY KEY (id);

CREATE TABLE egmeeseva_paymentDetails (
    id bigint NOT NULL,
    transactionRequestId bigint,
    applicantName character varying(50),
    districtid smallint,
    municipalCode character varying(50),
    mobileNo smallint,	
    totalAmount double precision,
    serviceAmount double precision, 
    userCharges double precision,
    postalCharges double precision,
    challanAmount double precision,
    printCharges double precision,
    departmentTransId character varying(50),
    slaEndDate timestamp without time zone,
    deliveryType character varying(50),
    transactionServiceId bigint,
    transactionServiceNumber character varying(50),
    createddate timestamp without time zone,
    lastmodifieddate timestamp without time zone,
    createdby bigint,
    lastmodifiedby bigint,
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_paymentDetails
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE ONLY egmeeseva_paymentDetails
    ADD CONSTRAINT pk_egmeeseva_paymentDetails PRIMARY KEY (id);



