/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.webservice.service;

import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.egov.meeseva.config.MeesevaApplicationProperties;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.webservice.client.GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult;
import org.egov.meeseva.webservice.client.GetPaymentTransIdResponseGetPaymentTransIdResult;
import org.egov.meeseva.webservice.client.MeeSevaWebServiceSoap;
import org.egov.meeseva.webservice.client.UpdateApplicationDetailsResponseUpdateApplicationDetailsResult;
import org.egov.meeseva.webservice.contract.MeeSevaInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MeeSevaWebService {
    private static final Logger LOG = Logger.getLogger(MeeSevaWebService.class);
    private static String SUCCESS = "SUCCESS";
    private final String DEFAULTVALUEZERO = "0";
    private final String DEFAULTVALUE = "";
    private final String NOTMENTIONED = "Not Mentioned";
    @Autowired
    private MeeSevaWebServiceSoap meeSevaWebServiceSoap;
    @Autowired
    private MeesevaApplicationProperties meesevaApplicationProperties;
    @Autowired
    private CheckSumService checkSumService;

    public boolean GetPaymentGatewayResponse(TransactionRequest meeSevaTransactionRequest) {
        String[] arrPaymentDetails = this.buildPaymentDetailsForPaymentGatewayReponse(meeSevaTransactionRequest.getApplicationNo(), meeSevaTransactionRequest);
        String[] arrAmount = this.buildArrAmount(meeSevaTransactionRequest);
        String[] arrTransParams = this.buildTransParamsForPaymentGatewayReponse();
        String[] arrTransDetails = this.buildTransDetailsForPaymentGatewayReponse(meeSevaTransactionRequest);
        String checksum = this.checkSumService.generateCheckSum(meeSevaTransactionRequest.getScaUserId(), meeSevaTransactionRequest.getScaPassword(), meeSevaTransactionRequest.getScaUserId(), meeSevaTransactionRequest.getOperaterId(), meeSevaTransactionRequest.getUniqueNo());
        MeeSevaInfo meeSevaInfo = null;
        try {
            GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult meesevaResponse = this.meeSevaWebServiceSoap.getPaymentGatewayResponse(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, this.meesevaApplicationProperties.meesevaWebServiceUserName(), this.meesevaApplicationProperties.meesevaWebServicePassword(), checksum);
            MessageElement[] messageElement = meesevaResponse.get_any();
            if (messageElement != null && messageElement.length > 0) {
                meeSevaInfo = this.buildMeeSevaInfoFromMeesevaReponse(messageElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return meeSevaInfo != null && meeSevaInfo.getMessage() != null && meeSevaInfo.getMessage().equalsIgnoreCase(SUCCESS);
    }

    public String getPaymentTransId(TransactionRequest meeSevaTransactionRequest) {
        MeeSevaInfo meeSevaInfo = null;
        String checksum = this.checkSumService.generateCheckSum(meeSevaTransactionRequest.getScaUserId(), meeSevaTransactionRequest.getScaPassword(), meeSevaTransactionRequest.getScaUserId(), meeSevaTransactionRequest.getOperaterId(), meeSevaTransactionRequest.getUniqueNo());
        String[] arrPaymentDetails = this.buildPaymentDetailsForPaymentTransactionId(meeSevaTransactionRequest.getApplicationNo(), meeSevaTransactionRequest);
        String[] arrAmount = this.buildArrAmount(meeSevaTransactionRequest);
        String[] arrTransParams = this.buildTransParamsForTransactionId();
        String[] arrTransDetails = this.buildTransDetailsForTransactionId(meeSevaTransactionRequest);
        try {
            GetPaymentTransIdResponseGetPaymentTransIdResult meesevaResponse = this.meeSevaWebServiceSoap.getPaymentTransId(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, this.meesevaApplicationProperties.meesevaWebServiceUserName(), this.meesevaApplicationProperties.meesevaWebServicePassword(), checksum);
            MessageElement[] messageElement = meesevaResponse.get_any();
            if (messageElement != null && messageElement.length > 0) {
                meeSevaInfo = this.buildMeeSevaInfoFromMeesevaReponse(messageElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (meeSevaInfo != null && meeSevaInfo.getErrorCode() != null && meeSevaInfo.getTransactionId() != null && meeSevaInfo.getErrorCode().equalsIgnoreCase("0")) {
            return meeSevaInfo.getTransactionId();
        }
        return null;
    }

    public boolean UpdateApplicationDetails(TransactionRequest meeSevaTransactionRequest, String updatedBy, String status, String remarks) {
        MeeSevaInfo meeSevaInfo = null;
        String checksum = this.checkSumService.generateCheckSumUpdate(meeSevaTransactionRequest.getApplicationNo(), status, updatedBy);
        try {
            UpdateApplicationDetailsResponseUpdateApplicationDetailsResult meesevaResponse = this.meeSevaWebServiceSoap.updateApplicationDetails(meeSevaTransactionRequest.getApplicationNo(), status, remarks, updatedBy, this.meesevaApplicationProperties.meesevaWebServiceUserName(), this.meesevaApplicationProperties.meesevaWebServicePassword(), meeSevaTransactionRequest.getOrganizationflag(), checksum);
            MessageElement[] messageElement = meesevaResponse.get_any();
            if (messageElement != null && messageElement.length > 0) {
                meeSevaInfo = this.buildMeeSevaInfoFromMeesevaReponse(messageElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return meeSevaInfo != null && meeSevaInfo.getMessage() != null && meeSevaInfo.getMessage().equalsIgnoreCase(SUCCESS);
    }

    private MeeSevaInfo buildMeeSevaInfoFromMeesevaReponse(MessageElement[] messageElement) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MeeSevaInfo.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        MeeSevaInfo meeSevaInfo = (MeeSevaInfo)unmarshaller.unmarshal((Reader)new StringReader(messageElement[0].toString()));
        LOG.debug((Object)(" Inside  getPaymentTransId " + messageElement[0].toString()));
        return meeSevaInfo;
    }

    public String[] buildArrAmount(TransactionRequest transactionRequest) {
        String[] arrAmount = new String[]{transactionRequest.getPaymentDetails().getUserCharges() != null ? transactionRequest.getPaymentDetails().getUserCharges().toString() : "0", transactionRequest.getPaymentDetails().getServiceAmount() != null ? transactionRequest.getPaymentDetails().getServiceAmount().toString() : "0", transactionRequest.getPaymentDetails().getPostalCharges() != null ? transactionRequest.getPaymentDetails().getPostalCharges().toString() : "0", transactionRequest.getPaymentDetails().getChallanAmount() != null ? transactionRequest.getPaymentDetails().getChallanAmount().toString() : "0", transactionRequest.getPaymentDetails().getPrintCharges() != null ? transactionRequest.getPaymentDetails().getPrintCharges().toString() : "0"};
        return arrAmount;
    }

    public String[] buildTransDetailsForPaymentGatewayReponse(TransactionRequest transactionRequest) {
        String[] arrTransDetails = new String[]{transactionRequest.getPaymentDetails().getApplicantName() != null ? transactionRequest.getPaymentDetails().getApplicantName() : "Not Mentioned", transactionRequest.getPaymentDetails().getDistrictid() != null ? transactionRequest.getPaymentDetails().getDistrictid().toString() : "", transactionRequest.getPaymentDetails().getMobileNo() != null ? transactionRequest.getPaymentDetails().getMobileNo() : "", transactionRequest.getPaymentDetails().getTotalAmount() != null ? transactionRequest.getPaymentDetails().getTotalAmount().toString() : "0"};
        return arrTransDetails;
    }

    public String[] buildTransDetailsForTransactionId(TransactionRequest transactionRequest) {
        String[] arrTransDetails = new String[9];
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        arrTransDetails[0] = transactionRequest.getPaymentDetails().getApplicantName() != null ? transactionRequest.getPaymentDetails().getApplicantName() : "Not Mentioned";
        arrTransDetails[1] = transactionRequest.getPaymentDetails().getDistrictid() != null ? transactionRequest.getPaymentDetails().getDistrictid() : "";
        arrTransDetails[2] = transactionRequest.getPaymentDetails().getMunicipalCode() != null ? transactionRequest.getPaymentDetails().getMunicipalCode() : "";
        arrTransDetails[3] = transactionRequest.getPaymentDetails().getMunicipalCode() != null ? transactionRequest.getPaymentDetails().getMunicipalCode() : "";
        arrTransDetails[4] = transactionRequest.getServiceId().getSla() != null ? transactionRequest.getServiceId().getSla().toString() : "";
        arrTransDetails[5] = transactionRequest.getPaymentDetails().getDeliveryType() != null ? transactionRequest.getPaymentDetails().getDeliveryType() : "MANUAL";
        arrTransDetails[6] = transactionRequest.getPaymentDetails().getTotalAmount() != null ? transactionRequest.getPaymentDetails().getTotalAmount().toString() : "0";
        arrTransDetails[7] = transactionRequest.getTransactionStatus() != null ? transactionRequest.getTransactionStatus() : "02";
        arrTransDetails[8] = transactionRequest.getPaymentDetails().getSlaEndDate() != null ? sdf.format(transactionRequest.getPaymentDetails().getSlaEndDate()) : "";
        return arrTransDetails;
    }

    public String[] buildTransParamsForPaymentGatewayReponse() {
        String[] arrTransParams = new String[]{"Applicant Name", "DistrictId", "MobileNo", "Total Amount"};
        return arrTransParams;
    }

    public String[] buildTransParamsForTransactionId() {
        String[] arrTransParams = new String[]{"Applicant Name", "District", "Mandal", "Village", "SLA", "DeliveryType", "TotalAmount", "Status", "SLAEnddate"};
        return arrTransParams;
    }

    public String[] buildPaymentDetailsForPaymentGatewayReponse(String applicationNumber, TransactionRequest transactionRequest) {
        String[] arrPaymentDetails = new String[]{transactionRequest.getUniqueNo(), transactionRequest.getScaUserId(), "CA", transactionRequest.getOperaterId(), transactionRequest.getChannelId(), applicationNumber, transactionRequest.getRequestId(), transactionRequest.getServiceId().getMeesevaServiceId(), transactionRequest.getScaPassword()};
        return arrPaymentDetails;
    }

    public String[] buildPaymentDetailsForPaymentTransactionId(String applicationNumber, TransactionRequest transactionRequest) {
        String[] arrPaymentDetails = new String[]{transactionRequest.getUniqueNo(), transactionRequest.getScaUserId(), "CA", transactionRequest.getOperaterId(), transactionRequest.getChannelId() != null ? transactionRequest.getChannelId() : "", applicationNumber, transactionRequest.getRequestId() != null ? transactionRequest.getRequestId() : "", transactionRequest.getServiceId().getMeesevaServiceId() != null ? transactionRequest.getServiceId().getMeesevaServiceId() : "", transactionRequest.getPaymentDetails().getReceiptNumber() != null ? transactionRequest.getPaymentDetails().getReceiptNumber() : "", "00", transactionRequest.getScaPassword(), transactionRequest.getOrganizationflag() != null ? transactionRequest.getOrganizationflag() : ""};
        return arrPaymentDetails;
    }
}

