/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.webservice;

import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.egov.meeseva.aop.CreatePropertyAdvice;
import org.egov.meeseva.config.MeesevaApplicationProperties;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.webservice.client.GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult;
import org.egov.meeseva.webservice.client.GetPaymentTransIdResponseGetPaymentTransIdResult;
import org.egov.meeseva.webservice.client.MeeSevaWebServiceSoapProxy;
import org.egov.meeseva.webservice.client.UpdateApplicationDetailsResponseUpdateApplicationDetailsResult;
import org.egov.meeseva.webservice.contract.MeeSevaInfo;

public class MeesevaClientSample {
    public static void main(String[] args) {
        Logger LOGGER = Logger.getLogger(CreatePropertyAdvice.class);
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"***********************");
                LOGGER.info((Object)"Create Web Service Client...");
                LOGGER.info((Object)("*********************** sla date " + MeesevaClientSample.getSlaEndDate(15)));
            }
            MeeSevaWebServiceSoapProxy serviceProxy = new MeeSevaWebServiceSoapProxy(new MeesevaApplicationProperties());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Create Web Service...");
            }
            CheckSumService checkSumService = new CheckSumService();
            String[] arrPaymentDetails = new String[]{"CCSP01AKT1", "01", "CA", "APO-ADI-AKT-1", "APO-ADI-AKT", "PTIS-001-234", "488BCAF6456", "1", "APONLINE"};
            String[] arrAmount = new String[]{"1000", "0", "0", "0", "0"};
            String[] arrTransParams = new String[]{"Applicant Name", "DistrictId", "MobileNo", "Total Amount"};
            String[] arrTransDetails = new String[]{"Applicant Name", "1", "9999999999", "1000"};
            String checksum = checkSumService.generateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1", "CCSP01AKT1");
            checkSumService.validateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1", "CCSP01AKT1", "701CCSP01AKT101APO-ADI-AKT-1APONLINEAPO-ADI-AKTCCSP01AKT101CCSP01A7");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("checksum ..." + checksum));
            }
            String checksumForPaymTransId = checkSumService.generateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1", "CCSP01AKT1");
            GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult response = serviceProxy.getPaymentGatewayResponse(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, "MEESEVA", "MEESEVA", checksum);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Call Web Service Operation...");
            }
            MessageElement[] messageElement = response.get_any();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MeeSevaInfo.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            String tempvar = messageElement[0].toString();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("tempvar said: " + tempvar));
            }
            MeeSevaInfo a = MeesevaClientSample.buildMeesevaInfo(unmarshaller, tempvar);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("result said: " + a.getMessage()));
            }
            String[] arrPaymentDetails1 = new String[]{"CCSP01AKT1", "01", "CA", "APO-ADI-AKT-1", "APO-ADI-AKT", "PTIS-001-234", "059292c9e2d", "3016", "DEPTTRAN1", "00", "APONLINE", "9"};
            String[] arrTransParams1 = new String[]{"Applicant Name", "District", "Mandal", "Village", "SLA", "DeliveryType", "TotalAmount", "Status", "SLAEnddate"};
            String[] arrTransDetails1 = new String[]{"Applicant Name", "112", "50004", "50004", "15", "MANUAL", "100", "0", "15/11/2015"};
            GetPaymentTransIdResponseGetPaymentTransIdResult response1 = serviceProxy.getPaymentTransId(arrPaymentDetails1, arrAmount, arrTransParams1, arrTransDetails1, "MEESEVA", "MEESEVA", checksumForPaymTransId);
            MessageElement[] messageElement1 = response1.get_any();
            String tempvar1 = messageElement1[0].toString();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("result said: " + tempvar1));
            }
            MeeSevaInfo b = MeesevaClientSample.buildMeesevaInfo(unmarshaller, tempvar1);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("result said: " + b.getErrorCode()));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Call Web Service Operation...");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Create Web Service...");
            }
            String thirdpartychecksum = checkSumService.generateCheckSumUpdate("PTIS01-00016-10112015-50001", "03", "ssss");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("*********************** thirdpartychecksum : " + thirdpartychecksum));
            }
            UpdateApplicationDetailsResponseUpdateApplicationDetailsResult thirdapiresponse = serviceProxy.updateApplicationDetails("PTIS01-00016-10112015-50001", "03", "STILL IN PROGRESS", "ssss", "MEESEVA", "MEESEVA", "9", thirdpartychecksum);
            MessageElement[] messageElement2 = thirdapiresponse.get_any();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("result said: " + messageElement2[0].toString()));
                LOGGER.info((Object)"***********************");
                LOGGER.info((Object)"Call Over!");
            }
        }
        catch (ExceptionInInitializerError ex) {
            ex.printStackTrace();
            LOGGER.error((Object)("error in ExceptionInInitializerError" + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error((Object)("error in Exception" + ex.getMessage()));
        }
    }

    private static MeeSevaInfo buildMeesevaInfo(Unmarshaller unmarshaller, String tempvar) throws JAXBException {
        MeeSevaInfo a = (MeeSevaInfo)unmarshaller.unmarshal((Reader)new StringReader(tempvar));
        return a;
    }

    private static Date getSlaEndDate(int long1) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, long1);
            return sdf.parse(sdf.format(cal.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

