/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.transactions.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.meeseva.masters.entity.Charges;
import org.egov.meeseva.masters.service.ChargesService;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.repository.TransactionRequestRepository;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.service.property.PropertyThirdPartyService;
import org.egov.wtms.integration.WaterChargesThirdPartyService;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TransactionRequestService {
    private final TransactionRequestRepository transactionRequestRepository;
    @Autowired
    private ChargesService chargesService;
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    private PropertyThirdPartyService propertyThirdPartyService;
    @Autowired
    private WaterChargesThirdPartyService waterChargesThirdPartyService;

    @Autowired
    public TransactionRequestService(TransactionRequestRepository transactionRequestRepository) {
        this.transactionRequestRepository = transactionRequestRepository;
    }

    public static Date getSlaEndDate(int workdays) {
        LocalDate date = new LocalDate();
        if (workdays < 1) {
            return date.toDate();
        }
        LocalDate result = date;
        int addedDays = 0;
        while (addedDays < workdays) {
            if ((result = result.plusDays(1)).getDayOfWeek() == 7) continue;
            ++addedDays;
        }
        return result.toDate();
    }

    @Transactional
    public void create(TransactionRequest request) {
        this.transactionRequestRepository.saveAndFlush((Object)request);
    }

    @Transactional
    public void update(TransactionRequest request) {
        this.transactionRequestRepository.saveAndFlush((Object)request);
    }

    @Transactional
    public void remove(TransactionRequest request) {
        this.transactionRequestRepository.delete((Object)request);
    }

    public TransactionRequest getRequestById(Long requestId) {
        return (TransactionRequest)((Object)this.transactionRequestRepository.findOne(requestId));
    }

    public TransactionRequest getRequestByUniqueNo(String uniqueNo) {
        return this.transactionRequestRepository.findByUniqueNo(uniqueNo);
    }

    public TransactionRequest getRequestByMeesevaRequestNo(String meesevaRequestNo) {
        return this.transactionRequestRepository.findByMeesevaRequestNo(meesevaRequestNo);
    }

    public TransactionRequest getRequestByMeesevaApplicationNo(String applicationNo) {
        return this.transactionRequestRepository.findByApplicationNo(applicationNo);
    }

    public TransactionRequest getRequestByTransactionServiceNumber(String serviceNumber) {
        return this.transactionRequestRepository.getRequestByTransactionServiceNumber(serviceNumber);
    }

    public void updatePaymentDetailsByApplicationNo(String applicationNo, PaymentDetails paymentDetails) {
        TransactionRequest request = this.transactionRequestRepository.findByApplicationNo(applicationNo);
        request.setPaymentDetails(paymentDetails);
        this.update(request);
    }

    public TransactionRequest updateChargesByServiceAndDeliveryType(String deliveryType, TransactionRequest transactionRequest) {
        List<Charges> chargesList = this.chargesService.getListOfChargesByServiceId(transactionRequest.getPaymentDetails().getTransactionRequestId().getServiceId().getId());
        double totalAmount = 0.0;
        for (Charges charges : chargesList) {
            if (charges.getType().toUpperCase().equalsIgnoreCase("SERVICEAMOUNT")) {
                transactionRequest.getPaymentDetails().setServiceAmount(charges.getValue());
                totalAmount += charges.getValue().doubleValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase("USERCHARGES")) {
                transactionRequest.getPaymentDetails().setUserCharges(charges.getValue());
                totalAmount += charges.getValue().doubleValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase("POSTALCHARGES-LOCAL") && deliveryType.equalsIgnoreCase("LOCAL")) {
                transactionRequest.getPaymentDetails().setPostalCharges(charges.getValue());
                totalAmount += charges.getValue().doubleValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase("POSTALCHARGES-NONLOCAL") && deliveryType.equalsIgnoreCase("NONLOCAL")) {
                transactionRequest.getPaymentDetails().setPostalCharges(charges.getValue());
                totalAmount += charges.getValue().doubleValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase("CHALLANAMOUNT")) {
                transactionRequest.getPaymentDetails().setChallanAmount(charges.getValue());
                totalAmount += charges.getValue().doubleValue();
            }
            if (!charges.getType().toUpperCase().equalsIgnoreCase("PRINTCHARGES")) continue;
            transactionRequest.getPaymentDetails().setPrintCharges(charges.getValue());
            totalAmount += charges.getValue().doubleValue();
        }
        transactionRequest.getPaymentDetails().setTotalAmount(totalAmount);
        return transactionRequest;
    }

    public void updatePaymentDetailsToMeeSeva(Integer count) {
        List<TransactionRequest> requestList = this.getRequestsToUpdatePayDetlToMeeSeva(count);
        for (TransactionRequest request : requestList) {
            String paymentGateWayResponse = this.meeSevaWebService.getPaymentTransId(request);
            this.buildTransactionRequestOnPaymentUpdate(request, paymentGateWayResponse);
            this.update(request);
        }
    }

    public void updateTransactionStatus(Integer count) {
        List<TransactionRequest> requestList = this.getRequestsToUpdateStatus(count);
        Map<String, String> statusCommentsMap = new HashMap<String, String>();
        for (TransactionRequest request : requestList) {
            boolean response;
            if (request.getServiceId().getCode().contains("PT")) {
                if (request.getServiceId().getCode().equalsIgnoreCase("PT07")) {
                    if (request.getPaymentDetails().getReceiptNumber() != null) {
                        statusCommentsMap.put("status", "Approved");
                        statusCommentsMap.put("updatedBy", "NA");
                        statusCommentsMap.put("comments", "NA");
                    } else {
                        statusCommentsMap.put("status", "Open");
                        statusCommentsMap.put("updatedBy", "NA");
                        statusCommentsMap.put("comments", "NA");
                    }
                } else {
                    statusCommentsMap = this.propertyThirdPartyService.validatePropertyStatus(request.getPaymentDetails().getTransactionServiceNumber(), MeesevaConstants.SERVICE_TYPE_APPLICATION_TYPE_MAP.get(request.getServiceId().getCode()));
                }
                if (statusCommentsMap.get("status") == null || ((String)statusCommentsMap.get("status")).equalsIgnoreCase("OPEN") || !(response = this.meeSevaWebService.UpdateApplicationDetails(request, (String)statusCommentsMap.get("updatedBy"), MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(((String)statusCommentsMap.get("status")).toUpperCase()), (String)statusCommentsMap.get("comments")))) continue;
                this.updateRequestStatus(request, statusCommentsMap);
                continue;
            }
            if (!request.getServiceId().getCode().contains("WT") || (statusCommentsMap = this.waterChargesThirdPartyService.validateWaterConnectionStatus(request.getPaymentDetails().getTransactionServiceNumber())).get("status") == null || ((String)statusCommentsMap.get("status")).equalsIgnoreCase("OPEN") || !(response = this.meeSevaWebService.UpdateApplicationDetails(request, (String)statusCommentsMap.get("updatedBy"), MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(((String)statusCommentsMap.get("status")).toUpperCase()), (String)statusCommentsMap.get("comments")))) continue;
            this.updateRequestStatus(request, statusCommentsMap);
        }
    }

    public void updateRequestStatus(TransactionRequest request, Map<String, String> statusCommentsMap) {
        request.setTransactionStatus(MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(statusCommentsMap.get("status").toUpperCase()));
        request.setStatusUpdateRemarks(statusCommentsMap.get("comments"));
        request.setStatusUpdated(true);
        request.setHistory(true);
        this.update(request);
    }

    public void buildTransactionRequestOnPaymentUpdate(TransactionRequest meeSevaTransactionRequest, String paymentGateWayResponse) {
        Date cal;
        if (paymentGateWayResponse != null) {
            meeSevaTransactionRequest.setMeesevaTransactionId(paymentGateWayResponse);
            meeSevaTransactionRequest.setPaymentUpdated(true);
            if (meeSevaTransactionRequest.getTransactionStatus() == null || meeSevaTransactionRequest.getTransactionStatus().equalsIgnoreCase("0") || meeSevaTransactionRequest.getTransactionStatus().equalsIgnoreCase("02")) {
                meeSevaTransactionRequest.setTransactionStatus("03");
            }
        }
        if (meeSevaTransactionRequest.getServiceId().getSla() != null && meeSevaTransactionRequest.getPaymentDetails().getSlaEndDate() == null && (cal = TransactionRequestService.getSlaEndDate(meeSevaTransactionRequest.getServiceId().getSla())) != null) {
            meeSevaTransactionRequest.getPaymentDetails().setSlaEndDate(cal);
        }
    }

    public List<TransactionRequest> getRequestsToUpdatePayDetlToMeeSeva(Integer count) {
        if (count != null && count > 0) {
            return this.transactionRequestRepository.getRequestsToUpdatePayDetlToMeeSeva((Pageable)new PageRequest(0, count.intValue()));
        }
        return this.transactionRequestRepository.getRequestsToUpdatePayDetlToMeeSeva();
    }

    public List<TransactionRequest> getRequestsToUpdateStatus(Integer count) {
        if (count != null && count > 0) {
            return this.transactionRequestRepository.getRequestsToUpdateStatus((Pageable)new PageRequest(0, count.intValue()), "03");
        }
        return this.transactionRequestRepository.getRequestsToUpdateStatus("03");
    }

    public boolean validateRequestByApplicationNo(String applicationNo) {
        TransactionRequest request = this.getRequestByMeesevaApplicationNo(applicationNo);
        return request.getPaymentDetails().getTransactionServiceId() == null;
    }
}

