/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.security.spring.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class EgovMeeSevaAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EgovMeeSevaAuthenticationSuccessHandler.class);
    private final RequestCache requestCache = new HttpSessionRequestCache();
    public static final String MEESEVA_REDIRECT_URL = "/meesevaservices-redirect";

    public EgovMeeSevaAuthenticationSuccessHandler() {
    }

    public EgovMeeSevaAuthenticationSuccessHandler(String defaultTargetUrl) {
        this.setDefaultTargetUrl(defaultTargetUrl);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String redirectUrl = this.getDefaultTargetUrl();
        if (savedRequest == null) {
            if (redirectUrl != null && redirectUrl.equals(MEESEVA_REDIRECT_URL) && request.getQueryString() != null) {
                this.getRedirectStrategy().sendRedirect(request, response, redirectUrl + "?" + request.getQueryString());
                return;
            }
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        String targetUrlParameter = this.getTargetUrlParameter();
        if (this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter))) {
            this.requestCache.removeRequest(request, response);
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        this.clearAuthenticationAttributes(request);
        String targetUrl = savedRequest.getRedirectUrl();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting to DefaultSavedRequest Url: " + targetUrl);
        }
        if (redirectUrl != null && targetUrl.equals(MEESEVA_REDIRECT_URL) && request.getQueryString() != null) {
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl + "?" + request.getQueryString());
        } else {
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
    }
}

