/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.security.spring.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.security.authentication.SecureUser;
import org.egov.meeseva.rest.service.CheckSumService;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class EgovMeeSevaAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private List<String> credentialFields = new ArrayList<String>();
    private RequestMatcher requiresAuthenticationRequestMatcher;
    public static final String USERAGENT_INFO = "userAgentInfo";

    public EgovMeeSevaAuthenticationProcessingFilter() {
        this.setRequiresAuthenticationRequestMatcher("/home");
    }

    public void setCredentialFields(List<String> credentialFields) {
        this.credentialFields = credentialFields;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authToken) {
        authToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Authentication authResult) throws IOException, ServletException {
        HttpSession session = request.getSession();
        if (authResult != null) {
            SecureUser principal = (SecureUser)authResult.getPrincipal();
            session.setAttribute("userid", (Object)principal.getUserId());
            session.setAttribute("username", (Object)principal.getUsername());
        }
        super.successfulAuthentication(request, response, filterChain, authResult);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        CheckSumService checkSumService = new CheckSumService();
        boolean validateChecksum = false;
        if (request.getParameter("enc") != null) {
            validateChecksum = checkSumService.validateMeeSevaRequest(request);
        } else if (request.getParameter("applicationNo") != null) {
            validateChecksum = true;
        }
        if (validateChecksum) {
            String username = request.getParameter("j_username");
            if (username == null || username.equals("")) {
                username = "meeseva";
            }
            String ipAddress = request.getRemoteAddr();
            String proxiedIPAddress = request.getHeader("X-Forwarded-For");
            if (StringUtils.isNotBlank((CharSequence)proxiedIPAddress)) {
                String[] ipAddresses = proxiedIPAddress.split(",");
                ipAddress = ipAddresses[ipAddresses.length - 1].trim();
            }
            String userAgentInfo = request.getHeader("User-Agent");
            HashMap<String, String> credentials = new HashMap<String, String>();
            for (String credential : this.credentialFields) {
                String field;
                String string = field = request.getParameter(credential) == null ? "" : request.getParameter(credential);
                if (credential.equals("ipAddress")) {
                    credentials.put(credential, ipAddress);
                    continue;
                }
                if (credential.equals(USERAGENT_INFO)) {
                    credentials.put(credential, userAgentInfo);
                    continue;
                }
                credentials.put(credential, field);
            }
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)username, credentials);
            request.getSession().setAttribute("j_username", (Object)username);
            this.setDetails(request, authToken);
            return this.getAuthenticationManager().authenticate((Authentication)authToken);
        }
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken(null, null);
        return this.getAuthenticationManager().authenticate((Authentication)authToken);
    }

    public final void setRequiresAuthenticationRequestMatcher(String requestMatcher) {
        this.requiresAuthenticationRequestMatcher = new AntPathRequestMatcher(requestMatcher);
    }
}

