/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.rest.service;

import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.egov.meeseva.utils.DecryptionUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="checkSumService")
@Transactional(readOnly=true)
public class CheckSumService {
    public boolean validateMeeSevaRequest(HttpServletRequest request) {
        HashMap<Object, Object> requestParms = new HashMap();
        requestParms = this.decryptInitialServiceRequestParameters(request);
        return this.validateCheckSum((String)requestParms.get("scaUserId"), (String)requestParms.get("scaPassword"), (String)requestParms.get("centerId"), (String)requestParms.get("operatorId"), (String)requestParms.get("uniqueNo"), (String)requestParms.get("Checksum"));
    }

    public HashMap<String, String> decryptInitialServiceRequestParameters(HttpServletRequest request) {
        HashMap<String, String> parms = new HashMap<String, String>();
        byte[] myIV = new byte[]{50, 51, 52, 53, 54, 55, 56, 57};
        byte[] tdesKeyData = new byte[]{-94, 21, 55, 7, -53, 98, -63, -45, -8, -15, -105, -33, -48, 19, 79, 121, 1, 103, 122, -123, -108, 22, 49, -110};
        DecryptionUtil objText = new DecryptionUtil(tdesKeyData, myIV);
        String meesevaRequestCode = request.getParameter("enc");
        String ulbCode = request.getParameter("ulbcode");
        String distCode = request.getParameter("distcode");
        if (meesevaRequestCode != null) {
            String strURL = null;
            try {
                strURL = objText.decryptText(meesevaRequestCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (strURL != null) {
                String[] values;
                for (String value : values = strURL.split("&")) {
                    String[] paramValues = value.split("=");
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P1")) {
                        parms.put("uniqueNo", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P2")) {
                        parms.put("scaUserId", paramValues[1]);
                        parms.put("centerId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P3")) {
                        parms.put("operatorId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P4")) {
                        parms.put("channelId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P5")) {
                        parms.put("Checksum", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P6")) {
                        parms.put("requestId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P7")) {
                        parms.put("serviceId", paramValues[1]);
                        parms.put("meesevaServiceId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P8")) {
                        parms.put("scaPassword", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P9")) {
                        parms.put("meesevaSequenceNumber", paramValues[1]);
                    }
                    if (paramValues == null || paramValues.length != 2 || !paramValues[0].equals("P10")) continue;
                    parms.put("flag", paramValues[1]);
                }
            }
        }
        parms.put("ulbcode", ulbCode);
        parms.put("distcode", distCode);
        return parms;
    }

    public boolean validateCheckSum(String scaUserId, String scaPassword, String centerId, String operatorId, String uniqueNo, String Checksum) {
        try {
            String generatedChecksum = Checksum.substring(1, Checksum.length() - 1);
            String str1 = centerId + uniqueNo;
            String str2 = operatorId;
            String check3 = str1 + scaUserId + str2 + scaPassword;
            Integer l1 = str1.length();
            Integer l2 = str2.length();
            String check1 = str1.substring(0, l1 - 3);
            String check2 = str2.substring(0, l2 - 2);
            return generatedChecksum.equals(check3 + check2 + uniqueNo + check1);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String generateCheckSum(String scaUserId, String scaPassword, String centerId, String operatorId, String uniqueNo) {
        String checkSum = "";
        try {
            String str1 = centerId + uniqueNo;
            String str2 = operatorId;
            String check3 = str1 + scaUserId + str2 + scaPassword;
            Integer l1 = str1.length();
            Integer l2 = str2.length();
            String check1 = str1.substring(0, l1 - 3);
            String check2 = str2.substring(0, l2 - 2);
            Random random = new Random();
            String check4 = Integer.valueOf(random.nextInt(9)).toString();
            checkSum = check4 + check3 + check2 + uniqueNo + check1 + check4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkSum;
    }

    public String generateCheckSumUpdate(String appno, String status, String updatedby) {
        String checkSum = "";
        try {
            String str1 = appno + status;
            String str2 = updatedby;
            Integer n1 = str1.length();
            Integer n2 = str2.length();
            String l1 = str1.substring(0, n1 - 3);
            String l2 = str2.substring(0, n2 - 2);
            Random random = new Random();
            String l4 = Integer.valueOf(random.nextInt(9)).toString();
            checkSum = l4 + l2 + l1 + l4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkSum;
    }

    public HashMap<String, String> decryptPrintCertificateParameters(HttpServletRequest request) {
        HashMap<String, String> parms = new HashMap<String, String>();
        byte[] myIV = new byte[]{50, 51, 52, 53, 54, 55, 56, 57};
        byte[] tdesKeyData = new byte[]{-94, 21, 55, 7, -53, 98, -63, -45, -8, -15, -105, -33, -48, 19, 79, 121, 1, 103, 122, -123, -108, 22, 49, -110};
        DecryptionUtil objText = new DecryptionUtil(tdesKeyData, myIV);
        if (request != null) {
            String strURL = null;
            try {
                strURL = objText.decryptText(request.getParameter("p1"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (strURL != null) {
                String[] values;
                for (String value : values = strURL.split("&")) {
                    String[] paramValues = value.split("=");
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P1")) {
                        parms.put("applicationNumber", paramValues[1]);
                    }
                    if (paramValues == null || paramValues.length != 2 || !paramValues[0].equals("P2")) continue;
                    parms.put("operatorId", paramValues[1]);
                }
            }
        }
        return parms;
    }
}

