/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.masters.service;

import java.util.List;
import org.egov.meeseva.masters.entity.Charges;
import org.egov.meeseva.masters.entity.Services;
import org.egov.meeseva.masters.repository.ChargesRepository;
import org.egov.meeseva.masters.service.MeeSevaServicesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ChargesService {
    private final ChargesRepository chargesRepository;
    @Autowired
    private MeeSevaServicesService meeSevaServicesService;

    @Autowired
    public ChargesService(ChargesRepository chargesRepository) {
        this.chargesRepository = chargesRepository;
    }

    public Double getChargesByServiceId(Long serviceId) {
        return this.chargesRepository.getChargesByServiceId(serviceId);
    }

    public Double getChargesByServiceName(String serviceName) {
        return this.chargesRepository.getChargesByServiceName(serviceName);
    }

    public Double getChargesByServiceCode(String serviceCode) {
        Services service = this.meeSevaServicesService.getServiceByCode(serviceCode);
        return this.chargesRepository.getChargesByServiceId(service.getId());
    }

    public List<Charges> getListOfChargesByServiceId(Long serviceId) {
        return this.chargesRepository.getListOfChargesByServiceId(serviceId);
    }
}

