/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.common.service;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.meeseva.masters.entity.Services;
import org.egov.meeseva.masters.service.MeeSevaServicesService;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="genericMeesevaService")
@Transactional(readOnly=true)
public class GenericMeesevaService {
    static final SimpleDateFormat sdf = new SimpleDateFormat("YYYY");
    private static final String APP_NUMBER_SEQ = "SEQ_EGMEESEVA_APPLICATIONNO_" + sdf.format(new Date());
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private MeeSevaServicesService meeSevaServicesService;

    public boolean validateServiceRequest(String sequenceNumber) {
        TransactionRequest request = this.transactionRequestService.getRequestByMeesevaRequestNo(sequenceNumber);
        return null == request;
    }

    public boolean validateMeesevaServiceId(String meesevaServiceId) {
        Services service = this.meeSevaServicesService.getServiceByMeesevaServiceId(meesevaServiceId);
        return null != service;
    }

    private String generateApplicationNo(String serviceCode, String sequenceNumber, Date toDay, String ulbCode) {
        SimpleDateFormat sdfr = new SimpleDateFormat("ddMMYYYY");
        return serviceCode + sequenceNumber + sdfr.format(toDay) + "UC" + ulbCode;
    }

    public TransactionRequest persistMeesevaRequest(HttpServletRequest request, HashMap<String, String> requestParms) {
        Object sequenceNumber;
        String ulbCode = "";
        String serviceCode = "";
        Date toDay = new Date();
        TransactionRequest meesevaReq = new TransactionRequest();
        PaymentDetails paymentDetails = new PaymentDetails();
        meesevaReq.setPaymentDetails(paymentDetails);
        paymentDetails.setTransactionRequestId(meesevaReq);
        if (null != requestParms.get("scaUserId")) {
            meesevaReq.setScaUserId(requestParms.get("scaUserId"));
        }
        if (null != requestParms.get("scaPassword")) {
            meesevaReq.setScaPassword(requestParms.get("scaPassword"));
        }
        if (null != requestParms.get("operatorId")) {
            meesevaReq.setOperaterId(requestParms.get("operatorId"));
        }
        if (null != requestParms.get("channelId")) {
            meesevaReq.setChannelId(requestParms.get("channelId"));
        }
        if (null != requestParms.get("uniqueNo")) {
            meesevaReq.setUniqueNo(requestParms.get("uniqueNo"));
        }
        if (null != requestParms.get("requestId")) {
            meesevaReq.setRequestId(requestParms.get("requestId"));
        }
        if (null != requestParms.get("flag")) {
            meesevaReq.setOrganizationflag(requestParms.get("flag"));
        }
        if (null != requestParms.get("meesevaSequenceNumber")) {
            meesevaReq.setMeesevaRequestNo(requestParms.get("meesevaSequenceNumber"));
        }
        if (null != requestParms.get("serviceId")) {
            meesevaReq.setServiceId(this.meeSevaServicesService.getServiceByMeesevaServiceId(requestParms.get("serviceId")));
            serviceCode = meesevaReq.getServiceId().getCode();
        }
        if (null != requestParms.get("ulbcode")) {
            ulbCode = requestParms.get("ulbcode");
            meesevaReq.getPaymentDetails().setMunicipalCode(requestParms.get("ulbcode"));
        }
        if (null != requestParms.get("distcode")) {
            meesevaReq.getPaymentDetails().setDistrictid(requestParms.get("distcode"));
        }
        try {
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(APP_NUMBER_SEQ);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(APP_NUMBER_SEQ);
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Application Number", (Throwable)e);
        }
        sequenceNumber = String.format("%s%05d", "", sequenceNumber);
        meesevaReq.setApplicationNo(this.generateApplicationNo(serviceCode, sequenceNumber.toString(), toDay, ulbCode));
        meesevaReq.setPaymentDetails(paymentDetails);
        this.transactionRequestService.create(meesevaReq);
        return meesevaReq;
    }

    private String generateReceiptNumber() {
        Object sequenceNumber;
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("YYYY");
        String strObj = "MEESEVA_RECEIPT_" + sdf2.format(new Date());
        try {
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(strObj);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(strObj);
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Application Number", (Throwable)e);
        }
        sequenceNumber = String.format("%s%04d", "", sequenceNumber);
        String result = sdf1.format(new Date()) + '/' + sdf2.format(new Date()) + '/' + sequenceNumber;
        return result;
    }

    public TransactionRequest updateReceiptDetails(TransactionRequest transactionRequest) {
        transactionRequest.getPaymentDetails().setReceiptNumber(this.generateReceiptNumber());
        transactionRequest.getPaymentDetails().setReceiptDate(new Date());
        return transactionRequest;
    }
}

