/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.aop;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class VacancyRemissionAdvice {
    private static final Logger LOGGER = Logger.getLogger(VacancyRemissionAdvice.class);
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Pointcut(value="execution(*  org.egov.ptis.domain.service.property.VacancyRemissionService.saveVacancyRemission (..)) && args(vacancyRemission,approvalPosition,approvalComent,additionalRule,workFlowAction,propertyByEmployee,meesevaParams)")
    private void paymentGatewayPointcutForVacRemission(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee, HashMap<String, String> meesevaParams) {
    }

    @Before(value="paymentGatewayPointcutForVacRemission(vacancyRemission,approvalPosition,approvalComent,additionalRule,workFlowAction,propertyByEmployee,meesevaParams)")
    public void getPaymentGatewayReponse(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee, HashMap<String, String> meesevaParams) {
        String applicationNumber = meesevaParams.get("APPLICATIONNUMBER");
        if (!this.transactionRequestService.validateRequestByApplicationNo(applicationNumber)) {
            throw new ApplicationRuntimeException("MEESEVA.002");
        }
        System.out.println("applicationNumber ------------------- " + applicationNumber);
        System.out.println("vacancyRemission application number ------------- " + vacancyRemission.getApplicationNumber());
        TransactionRequest meeSevaTransactionRequest = this.transactionRequestService.getRequestByMeesevaApplicationNo(applicationNumber);
        boolean paymentGateWayResponse = this.meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest);
        if (!paymentGateWayResponse) {
            throw new ApplicationRuntimeException("MEESEVA.004");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("paymentGateWayResponse " + paymentGateWayResponse));
        }
        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(vacancyRemission.getApplicationNumber());
        this.transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("called before " + paymentGateWayResponse));
        }
    }

    @AfterReturning(pointcut="paymentGatewayPointcutForVacRemission(org.egov.ptis.domain.entity.property.VacancyRemission,java.lang.Long,java.lang.String,java.lang.String,java.lang.String,java.lang.Boolean,java.util.HashMap)", returning="retVal")
    public void getPaymentGatewayTransactionId(Object retVal) {
        TransactionRequest meeSevaTransactionRequest;
        VacancyRemission vacancyRemission = (VacancyRemission)retVal;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("vacancyRemission application number  after " + vacancyRemission.getApplicationNumber()));
        }
        if ((meeSevaTransactionRequest = this.transactionRequestService.getRequestByTransactionServiceNumber(vacancyRemission.getApplicationNumber())) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo()));
            }
            this.genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);
            String paymentGateWayResponse = this.meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);
            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(vacancyRemission.getId());
            this.transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest, paymentGateWayResponse);
            this.transactionRequestService.update(meeSevaTransactionRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("called before " + paymentGateWayResponse));
            }
        }
    }
}

