/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.aop;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TaxExemptionAdvice {
    private static final Logger LOGGER = Logger.getLogger(TaxExemptionAdvice.class);
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Pointcut(value="execution(* org.egov.ptis.domain.service.exemption.TaxExemptionService.saveProperty(..)) && args(newProperty,oldProperty,status,approvalComment,workFlowAction,approvalPosition,taxExemptedReason,propertyByEmployee,additionalRule,meesevaParams)")
    private void paymentGatewayPointcutFortaxExemp(Property newProperty, Property oldProperty, Character status, String approvalComment, String workFlowAction, Long approvalPosition, String taxExemptedReason, Boolean propertyByEmployee, String additionalRule, HashMap<String, String> meesevaParams) {
    }

    @Before(value="paymentGatewayPointcutFortaxExemp(newProperty,oldProperty,status,approvalComment,workFlowAction,approvalPosition,taxExemptedReason,propertyByEmployee,additionalRule,meesevaParams)")
    public void getPaymentGatewayReponseFortaxExemp(Property newProperty, Property oldProperty, Character status, String approvalComment, String workFlowAction, Long approvalPosition, String taxExemptedReason, Boolean propertyByEmployee, String additionalRule, HashMap<String, String> meesevaParams) {
        TransactionRequest meeSevaTransactionRequest;
        boolean paymentGateWayResponse;
        String applicationNumber = meesevaParams.get("APPLICATIONNUMBER");
        if (!this.transactionRequestService.validateRequestByApplicationNo(applicationNumber)) {
            throw new ApplicationRuntimeException("MEESEVA.002");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("applicationNumber " + applicationNumber));
            LOGGER.debug((Object)("vacancyRemission application number" + ((PropertyImpl)newProperty).getApplicationNo()));
        }
        if (!(paymentGateWayResponse = this.meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest = this.transactionRequestService.getRequestByMeesevaApplicationNo(applicationNumber)))) {
            throw new ApplicationRuntimeException("MEESEVA.004");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("paymentGateWayResponse " + paymentGateWayResponse));
        }
        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(((PropertyImpl)newProperty).getApplicationNo());
        this.transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("called before " + paymentGateWayResponse));
        }
    }

    @AfterReturning(pointcut="paymentGatewayPointcutFortaxExemp(org.egov.ptis.domain.entity.property.Property,org.egov.ptis.domain.entity.property.Property,java.lang.Character,java.lang.String,java.lang.String,java.lang.Long,java.lang.String,java.lang.Boolean,java.lang.String,java.util.HashMap)", returning="retVal")
    public void getPaymentGatewayTransactionIdFortaxExemp(Object retVal) {
        TransactionRequest meeSevaTransactionRequest;
        BasicPropertyImpl property = (BasicPropertyImpl)retVal;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("vacancyRemission application number  after " + property.getWFProperty().getApplicationNo()));
        }
        if ((meeSevaTransactionRequest = this.transactionRequestService.getRequestByTransactionServiceNumber(property.getWFProperty().getApplicationNo())) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo()));
            }
            this.genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);
            String paymentGateWayResponse = this.meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);
            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(property.getId());
            this.transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest, paymentGateWayResponse);
            this.transactionRequestService.update(meeSevaTransactionRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("called before " + paymentGateWayResponse));
            }
        }
    }
}

