/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.aop;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.aop.ModifyPropertyAdvice;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RevisionPetitionAdvice {
    private static final Logger LOGGER = Logger.getLogger(ModifyPropertyAdvice.class);
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Pointcut(value="execution(*  org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService.createRevisionPetition (..)) && args(objection,meesevaParams)")
    private void paymentGatewayPointcut(RevisionPetition objection, HashMap<String, String> meesevaParams) {
    }

    @Before(value="paymentGatewayPointcut(objection,meesevaParams)")
    public void getPaymentGatewayReponse(RevisionPetition objection, HashMap<String, String> meesevaParams) {
        TransactionRequest meeSevaTransactionRequest;
        boolean paymentGateWayResponse;
        String applicationNumber = meesevaParams.get("APPLICATIONNUMBER");
        if (!this.transactionRequestService.validateRequestByApplicationNo(applicationNumber)) {
            throw new ApplicationRuntimeException("MEESEVA.002");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("applicationNumber " + applicationNumber));
        }
        if (!(paymentGateWayResponse = this.meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest = this.transactionRequestService.getRequestByMeesevaApplicationNo(applicationNumber)))) {
            throw new ApplicationRuntimeException("MEESEVA.004");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("paymentGateWayResponse " + paymentGateWayResponse));
        }
        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(objection.getObjectionNumber());
        this.transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("called before " + paymentGateWayResponse));
        }
    }

    @AfterReturning(pointcut="paymentGatewayPointcut(org.egov.ptis.domain.entity.objection.RevisionPetition,java.util.HashMap)", returning="retVal")
    public void getPaymentGatewayTransactionId(Object retVal) {
        TransactionRequest meeSevaTransactionRequest;
        RevisionPetition objection = (RevisionPetition)retVal;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("basicProperty.getUpicNo()  after " + objection.getBasicProperty().getUpicNo()));
        }
        if ((meeSevaTransactionRequest = this.transactionRequestService.getRequestByTransactionServiceNumber(objection.getObjectionNumber())) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo()));
            }
            this.genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);
            String paymentGateWayResponse = this.meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);
            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(objection.getId());
            this.transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest, paymentGateWayResponse);
            this.transactionRequestService.update(meeSevaTransactionRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("called before " + paymentGateWayResponse));
            }
        }
    }
}

