/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.aop;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class NewWaterConnectionAdvice {
    private static final Logger LOGGER = Logger.getLogger(NewWaterConnectionAdvice.class);
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Pointcut(value="execution(* org.egov.wtms.application.service.WaterConnectionDetailsService.createNewWaterConnection (..)) && args(waterConnectionDetails,approvalPosition,approvalComent,code,workFlowAction,meesevaParams,sourceChannel)")
    private void paymentGatewayPointcutForWaterTax(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String code, String workFlowAction, HashMap<String, String> meesevaParams, String sourceChannel) {
    }

    @Before(value="paymentGatewayPointcutForWaterTax(waterConnectionDetails,approvalPosition,approvalComent,code,workFlowAction,meesevaParams,sourceChannel)")
    public void getPaymentGatewayReponse(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String code, String workFlowAction, HashMap<String, String> meesevaParams, String sourceChannel) {
        TransactionRequest meeSevaTransactionRequest;
        boolean paymentGateWayResponse;
        String applicationNumber = meesevaParams.get("APPLICATIONNUMBER");
        if (!this.transactionRequestService.validateRequestByApplicationNo(applicationNumber)) {
            throw new ApplicationRuntimeException("MEESEVA.002");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("applicationNumber " + applicationNumber));
            LOGGER.debug((Object)("new water tap connection applicationNumber" + waterConnectionDetails.getApplicationNumber()));
        }
        if (!(paymentGateWayResponse = this.meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest = this.transactionRequestService.getRequestByMeesevaApplicationNo(applicationNumber)))) {
            throw new ApplicationRuntimeException("MEESEVA.004");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("paymentGateWayResponse " + paymentGateWayResponse));
        }
        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(waterConnectionDetails.getApplicationNumber());
        this.transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("called before " + paymentGateWayResponse));
        }
    }

    @AfterReturning(pointcut="paymentGatewayPointcutForWaterTax(org.egov.wtms.application.entity.WaterConnectionDetails,java.lang.Long,java.lang.String,java.lang.String,java.lang.String,java.util.HashMap,java.lang.String)", returning="retVal")
    public void getPaymentGatewayTransactionId(Object retVal) {
        WaterConnectionDetails waterConnectionDetails = (WaterConnectionDetails)retVal;
        TransactionRequest meeSevaTransactionRequest = this.transactionRequestService.getRequestByTransactionServiceNumber(waterConnectionDetails.getApplicationNumber());
        if (meeSevaTransactionRequest != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo()));
            }
            this.genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);
            String paymentGateWayResponse = this.meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);
            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(waterConnectionDetails.getId());
            this.transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest, paymentGateWayResponse);
            this.transactionRequestService.update(meeSevaTransactionRequest);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("called before " + paymentGateWayResponse));
            }
        }
    }
}

