/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.webservice.service;

import java.io.StringReader;
import java.text.SimpleDateFormat;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.egov.meeseva.config.MeesevaApplicationProperties;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.meeseva.webservice.client.GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult;
import org.egov.meeseva.webservice.client.GetPaymentTransIdResponseGetPaymentTransIdResult;
import org.egov.meeseva.webservice.client.MeeSevaWebServiceSoap;
import org.egov.meeseva.webservice.client.UpdateApplicationDetailsResponseUpdateApplicationDetailsResult;
import org.egov.meeseva.webservice.contract.MeeSevaInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly = true)
public class MeeSevaWebService {
    private static final Logger LOG = Logger.getLogger(MeeSevaWebService.class);

    private static String SUCCESS = "SUCCESS";
    private final String DEFAULTVALUEZERO = "0";
    private final String DEFAULTVALUE = "";
    private final String NOTMENTIONED = "Not Mentioned";
    @Autowired
    private MeeSevaWebServiceSoap meeSevaWebServiceSoap;

    @Autowired
    private MeesevaApplicationProperties meesevaApplicationProperties;

    
    @Autowired
    private CheckSumService checkSumService;

    public boolean GetPaymentGatewayResponse(final TransactionRequest meeSevaTransactionRequest) {

        final String[] arrPaymentDetails = buildPaymentDetailsForPaymentGatewayReponse(
                meeSevaTransactionRequest.getApplicationNo(),
                meeSevaTransactionRequest);
        final String[] arrAmount = buildArrAmount(meeSevaTransactionRequest);
        final String[] arrTransParams = buildTransParamsForPaymentGatewayReponse();
        final String[] arrTransDetails = buildTransDetailsForPaymentGatewayReponse(meeSevaTransactionRequest);
        final String checksum = checkSumService.generateCheckSum(meeSevaTransactionRequest.getScaUserId(),
                meeSevaTransactionRequest.getScaPassword(), meeSevaTransactionRequest.getScaUserId(),
                meeSevaTransactionRequest.getOperaterId(), meeSevaTransactionRequest.getUniqueNo());

        MeeSevaInfo meeSevaInfo = null;

        try {
            final GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult meesevaResponse = meeSevaWebServiceSoap
                    .getPaymentGatewayResponse(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails,
                    		meesevaApplicationProperties.meesevaWebServiceUserName() , meesevaApplicationProperties.meesevaWebServicePassword(), checksum);
            final MessageElement[] messageElement = meesevaResponse.get_any();

            if (messageElement != null && messageElement.length > 0)
                meeSevaInfo = buildMeeSevaInfoFromMeesevaReponse(messageElement);
        } catch (final Exception e) {
            e.printStackTrace();
        }

        if (meeSevaInfo != null && meeSevaInfo.getMessage() != null
                && meeSevaInfo.getMessage().equalsIgnoreCase(SUCCESS))
            return true;
        else
            return false;

    }

    public String getPaymentTransId(final TransactionRequest meeSevaTransactionRequest) {
        MeeSevaInfo meeSevaInfo = null;
        final String checksum = checkSumService.generateCheckSum(meeSevaTransactionRequest.getScaUserId(),
                meeSevaTransactionRequest.getScaPassword(), meeSevaTransactionRequest.getScaUserId(),
                meeSevaTransactionRequest.getOperaterId(), meeSevaTransactionRequest.getUniqueNo());

        final String[] arrPaymentDetails = buildPaymentDetailsForPaymentTransactionId(
                meeSevaTransactionRequest.getApplicationNo(), meeSevaTransactionRequest);
        final String[] arrAmount = buildArrAmount(meeSevaTransactionRequest);
        final String[] arrTransParams = buildTransParamsForTransactionId();
        final String[] arrTransDetails = buildTransDetailsForTransactionId(meeSevaTransactionRequest);

        try {
            final GetPaymentTransIdResponseGetPaymentTransIdResult meesevaResponse = meeSevaWebServiceSoap
                    .getPaymentTransId(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, meesevaApplicationProperties.meesevaWebServiceUserName(),
                            meesevaApplicationProperties.meesevaWebServicePassword(), checksum);
            final MessageElement[] messageElement = meesevaResponse.get_any();

            if (messageElement != null && messageElement.length > 0)
                meeSevaInfo = buildMeeSevaInfoFromMeesevaReponse(messageElement);
        } catch (final Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (meeSevaInfo != null && meeSevaInfo.getErrorCode() != null && meeSevaInfo.getTransactionId() != null
                && meeSevaInfo.getErrorCode().equalsIgnoreCase(DEFAULTVALUEZERO))
            return meeSevaInfo.getTransactionId();

        return null;

    }

    public boolean UpdateApplicationDetails(final TransactionRequest meeSevaTransactionRequest, final String updatedBy,
            final String status, final String remarks) {

        MeeSevaInfo meeSevaInfo = null;
        final String checksum = checkSumService.generateCheckSumUpdate(
                meeSevaTransactionRequest.getApplicationNo(),
                status, updatedBy);
        try {
            final UpdateApplicationDetailsResponseUpdateApplicationDetailsResult meesevaResponse = meeSevaWebServiceSoap
                    .updateApplicationDetails(
                            meeSevaTransactionRequest.getApplicationNo(), status, remarks, updatedBy, meesevaApplicationProperties.meesevaWebServiceUserName(),
                            meesevaApplicationProperties.meesevaWebServicePassword(),
                            meeSevaTransactionRequest.getOrganizationflag(), checksum);
            final MessageElement[] messageElement = meesevaResponse.get_any();

            if (messageElement != null && messageElement.length > 0)
                meeSevaInfo = buildMeeSevaInfoFromMeesevaReponse(messageElement);

        } catch (final Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        if (meeSevaInfo != null && meeSevaInfo.getMessage() != null
                && meeSevaInfo.getMessage().equalsIgnoreCase(SUCCESS))
            return true;
        else
            return false;

    }

    private MeeSevaInfo buildMeeSevaInfoFromMeesevaReponse(
            final MessageElement[] messageElement) throws JAXBException {
        MeeSevaInfo meeSevaInfo;
        final JAXBContext jaxbContext = JAXBContext.newInstance(MeeSevaInfo.class);
        final Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        meeSevaInfo = (MeeSevaInfo) unmarshaller.unmarshal(new StringReader(
                messageElement[0].toString()));
        LOG.debug(" Inside  getPaymentTransId " + messageElement[0].toString());

        return meeSevaInfo;
    }

    public String[] buildArrAmount(final TransactionRequest transactionRequest) {
        final String[] arrAmount = new String[5];

        arrAmount[0] = transactionRequest.getPaymentDetails().getUserCharges() != null ? transactionRequest.getPaymentDetails()
                .getUserCharges().toString() : DEFAULTVALUEZERO;
        arrAmount[1] = transactionRequest.getPaymentDetails().getServiceAmount() != null ? transactionRequest.getPaymentDetails()
                .getServiceAmount().toString() : DEFAULTVALUEZERO;
        arrAmount[2] = transactionRequest.getPaymentDetails().getPostalCharges() != null ? transactionRequest.getPaymentDetails()
                .getPostalCharges().toString() : DEFAULTVALUEZERO;
        arrAmount[3] = transactionRequest.getPaymentDetails().getChallanAmount() != null ? transactionRequest.getPaymentDetails()
                .getChallanAmount().toString() : DEFAULTVALUEZERO;
        arrAmount[4] = transactionRequest.getPaymentDetails().getPrintCharges() != null ? transactionRequest.getPaymentDetails()
                .getPrintCharges().toString() : DEFAULTVALUEZERO;
        return arrAmount;
    }

    public String[] buildTransDetailsForPaymentGatewayReponse(final TransactionRequest transactionRequest) {
        final String[] arrTransDetails = new String[4];

        arrTransDetails[0] = transactionRequest.getPaymentDetails().getApplicantName() != null ? transactionRequest
                .getPaymentDetails().getApplicantName() : NOTMENTIONED;

        arrTransDetails[1] = transactionRequest.getPaymentDetails().getDistrictid() != null ? transactionRequest
                .getPaymentDetails().getDistrictid().toString() : DEFAULTVALUE;
        arrTransDetails[2] = transactionRequest.getPaymentDetails().getMobileNo() != null ? transactionRequest
                .getPaymentDetails().getMobileNo() : DEFAULTVALUE;
        arrTransDetails[3] = transactionRequest.getPaymentDetails().getTotalAmount() != null ? transactionRequest
                .getPaymentDetails().getTotalAmount().toString() : DEFAULTVALUEZERO;
        return arrTransDetails;
    }

    public String[] buildTransDetailsForTransactionId(
            final TransactionRequest transactionRequest) {
        final String[] arrTransDetails = new String[9];
        final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

        arrTransDetails[0] = transactionRequest.getPaymentDetails().getApplicantName() != null ? transactionRequest
                .getPaymentDetails().getApplicantName() : NOTMENTIONED;
        arrTransDetails[1] = transactionRequest.getPaymentDetails().getDistrictid() != null ? transactionRequest
                .getPaymentDetails().getDistrictid() : DEFAULTVALUE;
        arrTransDetails[2] = transactionRequest.getPaymentDetails().getMunicipalCode() != null ? transactionRequest
                .getPaymentDetails().getMunicipalCode() : DEFAULTVALUE;
        arrTransDetails[3] = transactionRequest.getPaymentDetails().getMunicipalCode() != null ? transactionRequest
                .getPaymentDetails().getMunicipalCode() : DEFAULTVALUE;
        arrTransDetails[4] = transactionRequest.getServiceId().getSla() != null ? transactionRequest.getServiceId().getSla()
                .toString() : DEFAULTVALUE;
        arrTransDetails[5] = transactionRequest.getPaymentDetails().getDeliveryType() != null ? transactionRequest
                .getPaymentDetails().getDeliveryType() : "MANUAL";
        arrTransDetails[6] = transactionRequest.getPaymentDetails().getTotalAmount() != null ? transactionRequest
                .getPaymentDetails().getTotalAmount().toString() : DEFAULTVALUEZERO;
        arrTransDetails[7] = transactionRequest.getTransactionStatus() != null ? transactionRequest.getTransactionStatus()
                : MeesevaConstants.TRANSACTIONSTATUSNOTVIEWED;
        arrTransDetails[8] = transactionRequest.getPaymentDetails().getSlaEndDate() != null ? sdf.format(transactionRequest
                .getPaymentDetails().getSlaEndDate()) : DEFAULTVALUE;

        return arrTransDetails;
    }

    public String[] buildTransParamsForPaymentGatewayReponse() {
        final String[] arrTransParams = new String[4];
        arrTransParams[0] = "Applicant Name";
        arrTransParams[1] = "DistrictId";
        arrTransParams[2] = "MobileNo";
        arrTransParams[3] = "Total Amount";
        return arrTransParams;
    }

    public String[] buildTransParamsForTransactionId() {
        final String[] arrTransParams = new String[9];
        arrTransParams[0] = "Applicant Name";
        arrTransParams[1] = "District";
        arrTransParams[2] = "Mandal";
        arrTransParams[3] = "Village";
        arrTransParams[4] = "SLA";
        arrTransParams[5] = "DeliveryType";
        arrTransParams[6] = "TotalAmount";
        arrTransParams[7] = "Status";
        arrTransParams[8] = "SLAEnddate";

        return arrTransParams;
    }

    public String[] buildPaymentDetailsForPaymentGatewayReponse(final String applicationNumber,
            final TransactionRequest transactionRequest) {
        final String[] arrPaymentDetails = new String[9];

        arrPaymentDetails[0] = transactionRequest.getUniqueNo();
        arrPaymentDetails[1] = transactionRequest.getScaUserId();
        arrPaymentDetails[2] = "CA";
        arrPaymentDetails[3] = transactionRequest.getOperaterId();
        arrPaymentDetails[4] = transactionRequest.getChannelId();
        arrPaymentDetails[5] = applicationNumber;
        arrPaymentDetails[6] = transactionRequest.getRequestId();
        arrPaymentDetails[7] = transactionRequest.getServiceId().getMeesevaServiceId();
        arrPaymentDetails[8] = transactionRequest.getScaPassword();
        return arrPaymentDetails;
    }

    public String[] buildPaymentDetailsForPaymentTransactionId(final String applicationNumber,
            final TransactionRequest transactionRequest) {
        final String[] arrPaymentDetails = new String[12];

        arrPaymentDetails[0] = transactionRequest.getUniqueNo();
        arrPaymentDetails[1] = transactionRequest.getScaUserId();
        arrPaymentDetails[2] = "CA";
        arrPaymentDetails[3] = transactionRequest.getOperaterId();//USERID
        arrPaymentDetails[4] = transactionRequest.getChannelId() != null ? transactionRequest.getChannelId() : DEFAULTVALUE;//CHANNALID
        arrPaymentDetails[5] = applicationNumber;//APPLICATION NUMBER
        arrPaymentDetails[6] = transactionRequest.getRequestId() != null ? transactionRequest.getRequestId() : DEFAULTVALUE;//REQUESTID
        arrPaymentDetails[7] = transactionRequest.getServiceId().getMeesevaServiceId() != null ? transactionRequest
                .getServiceId().getMeesevaServiceId() : DEFAULTVALUE;//SERVICEID
        arrPaymentDetails[8] = transactionRequest.getPaymentDetails().getReceiptNumber() != null ? transactionRequest
                .getPaymentDetails().getReceiptNumber() : DEFAULTVALUE;//DepartmentTransId
        arrPaymentDetails[9] = "00";//servicetypeid
        arrPaymentDetails[10] = transactionRequest.getScaPassword();//SCAPassword
        arrPaymentDetails[11] = transactionRequest.getOrganizationflag()!=null?transactionRequest.getOrganizationflag():DEFAULTVALUE;//flag
        return arrPaymentDetails;
    }

}
