/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.webservice.client;

import org.egov.meeseva.config.MeesevaApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeeSevaWebServiceSoapProxy implements org.egov.meeseva.webservice.client.MeeSevaWebServiceSoap {
    private String _endpoint = null;
    private org.egov.meeseva.webservice.client.MeeSevaWebServiceSoap meeSevaWebServiceSoap = null;
   
	private MeesevaApplicationProperties meesevaApplicationProperties;

	@Autowired
	public MeeSevaWebServiceSoapProxy(
			MeesevaApplicationProperties meesevaApplicationProperties) {
		this.meesevaApplicationProperties = meesevaApplicationProperties;
		_initMeeSevaWebServiceSoapProxy();
	}

    public MeeSevaWebServiceSoapProxy(final String endpoint) {
        _endpoint = endpoint;
        _initMeeSevaWebServiceSoapProxy();
    }

    private void _initMeeSevaWebServiceSoapProxy() {
        try {
			if (meesevaApplicationProperties != null) {
				this.meeSevaWebServiceSoap = new org.egov.meeseva.webservice.client.MeeSevaWebServiceLocator(
						meesevaApplicationProperties.meesevaWebServiceSoapAddress()).getMeeSevaWebServiceSoap();
			} else
				this.meeSevaWebServiceSoap = new org.egov.meeseva.webservice.client.MeeSevaWebServiceLocator()
						.getMeeSevaWebServiceSoap();
			if (meeSevaWebServiceSoap != null)
                if (_endpoint != null)
                    ((javax.xml.rpc.Stub) meeSevaWebServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address",
                            _endpoint);
                else
                    _endpoint = (String) ((javax.xml.rpc.Stub) meeSevaWebServiceSoap)
                            ._getProperty("javax.xml.rpc.service.endpoint.address");

        } catch (final javax.xml.rpc.ServiceException serviceException) {
        }
    }

    public String getEndpoint() {
        return _endpoint;
    }

    public void setEndpoint(final String endpoint) {
        _endpoint = endpoint;
        if (meeSevaWebServiceSoap != null)
            ((javax.xml.rpc.Stub) meeSevaWebServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);

    }

    public org.egov.meeseva.webservice.client.MeeSevaWebServiceSoap getMeeSevaWebServiceSoap() {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap;
    }

    @Override
    public org.egov.meeseva.webservice.client.GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult getPaymentGatewayResponse(
            final java.lang.String[] arrPaymentDetails, final java.lang.String[] arrAmount,
            final java.lang.String[] arrTransParams, final java.lang.String[] arrTransDetails, final java.lang.String userid,
            final java.lang.String password, final java.lang.String checksum) throws java.rmi.RemoteException {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap.getPaymentGatewayResponse(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails,
                userid, password, checksum);
    }

    @Override
    public org.egov.meeseva.webservice.client.GetPaymentTransIdResponseGetPaymentTransIdResult getPaymentTransId(
            final java.lang.String[] arrPaymentDetails, final java.lang.String[] arrAmount,
            final java.lang.String[] arrTransParams, final java.lang.String[] arrTransDetails, final java.lang.String userid,
            final java.lang.String password, final java.lang.String checksum) throws java.rmi.RemoteException {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap.getPaymentTransId(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, userid,
                password, checksum);
    }

    @Override
    public org.egov.meeseva.webservice.client.UpdateApplicationDetailsResponseUpdateApplicationDetailsResult updateApplicationDetails(
            final java.lang.String appno, final java.lang.String status, final java.lang.String remarks,
            final java.lang.String updatedby, final java.lang.String userid, final java.lang.String password,
            final java.lang.String deptFlag, final java.lang.String checksum) throws java.rmi.RemoteException {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap.updateApplicationDetails(appno, status, remarks, updatedby, userid, password, deptFlag,
                checksum);
    }

    @Override
    public org.egov.meeseva.webservice.client.GetPaymentTransIdonlineResponseGetPaymentTransIdonlineResult getPaymentTransIdonline(
            final java.lang.String[] arrPaymentDetails, final java.lang.String[] arrAmount,
            final java.lang.String[] arrTransParams, final java.lang.String[] arrTransDetails, final java.lang.String userid,
            final java.lang.String password, final java.lang.String checksum) throws java.rmi.RemoteException {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap.getPaymentTransIdonline(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails,
                userid, password, checksum);
    }

    @Override
    public boolean updateChannelActiveInactiveDetails(final java.lang.String PScaId, final java.lang.String scaId,
            final java.lang.String filePath, final java.lang.String fileName, final java.lang.String channelid,
            final java.lang.String channelName, final java.lang.String ownerName, final java.lang.String status,
            final java.lang.String remarks, final java.lang.String systemIP, final java.lang.String createdBy,
            final java.lang.String hash) throws java.rmi.RemoteException {
        if (meeSevaWebServiceSoap == null)
            _initMeeSevaWebServiceSoapProxy();
        return meeSevaWebServiceSoap.updateChannelActiveInactiveDetails(PScaId, scaId, filePath, fileName, channelid, channelName,
                ownerName, status, remarks, systemIP, createdBy, hash);
    }

}
