/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.webservice;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.egov.meeseva.aop.CreatePropertyAdvice;
import org.egov.meeseva.config.MeesevaApplicationProperties;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.webservice.client.GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult;
import org.egov.meeseva.webservice.client.GetPaymentTransIdResponseGetPaymentTransIdResult;
import org.egov.meeseva.webservice.client.MeeSevaWebServiceSoapProxy;
import org.egov.meeseva.webservice.client.UpdateApplicationDetailsResponseUpdateApplicationDetailsResult;
import org.egov.meeseva.webservice.contract.MeeSevaInfo;

public class MeesevaClientSample {

    public static void main(final String[] args) {

        final Logger LOGGER = Logger.getLogger(CreatePropertyAdvice.class);
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("***********************");
                LOGGER.info("Create Web Service Client...");
                LOGGER.info("*********************** sla date " + getSlaEndDate(15));
            }
            final MeeSevaWebServiceSoapProxy serviceProxy = new MeeSevaWebServiceSoapProxy(new MeesevaApplicationProperties());

            if (LOGGER.isInfoEnabled())
                LOGGER.info("Create Web Service...");
            final CheckSumService checkSumService = new CheckSumService();

            final String[] arrPaymentDetails = new String[9];

            arrPaymentDetails[0] = "CCSP01AKT1";
            arrPaymentDetails[1] = "01";
            arrPaymentDetails[2] = "CA";
            arrPaymentDetails[3] = "APO-ADI-AKT-1";
            arrPaymentDetails[4] = "APO-ADI-AKT";
            arrPaymentDetails[5] = "PTIS-001-234";
            arrPaymentDetails[6] = "488BCAF6456";
            arrPaymentDetails[7] = "1";
            arrPaymentDetails[8] = "APONLINE";

            final String[] arrAmount = new String[5];
            arrAmount[0] = "1000";
            arrAmount[1] = "0";
            arrAmount[2] = "0";
            arrAmount[3] = "0";
            arrAmount[4] = "0";

            final String[] arrTransParams = new String[4];
            arrTransParams[0] = "Applicant Name";
            arrTransParams[1] = "DistrictId";
            arrTransParams[2] = "MobileNo";
            arrTransParams[3] = "Total Amount";
            // arrTransParams[4]= "Total Amount1";

            final String[] arrTransDetails = new String[4];

            arrTransDetails[0] = "Applicant Name";
            arrTransDetails[1] = "1";
            arrTransDetails[2] = "9999999999";
            arrTransDetails[3] = "1000";
            // arrTransDetails[4] = "1000";

            final String checksum = checkSumService.generateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1", "CCSP01AKT1");

            checkSumService.validateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1", "CCSP01AKT1",
                    "701CCSP01AKT101APO-ADI-AKT-1APONLINEAPO-ADI-AKTCCSP01AKT101CCSP01A7");
            if (LOGGER.isInfoEnabled())
                LOGGER.info("checksum ..." + checksum);

            final String checksumForPaymTransId = checkSumService.generateCheckSum("01", "APONLINE", "01", "APO-ADI-AKT-1",
                    "CCSP01AKT1");
            // First API call.
            final GetPaymentGatewayResponseResponseGetPaymentGatewayResponseResult response = serviceProxy
                    .getPaymentGatewayResponse(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, "MEESEVA",
                            "MEESEVA", checksum);
            if (LOGGER.isInfoEnabled())
                LOGGER.info("Call Web Service Operation...");

            final MessageElement[] messageElement = response.get_any();
            // MeeSevaInfo result= (MeeSevaInfo) response.getDeserializer(messageElement[0].toString(), MeeSevaInfo.class, new
            // javax.xml.namespace.QName("http://tempuri.org/",
            // ">>GetPaymentGatewayResponseResponse>GetPaymentGatewayResponseResult")).getValue();

            final JAXBContext jaxbContext = JAXBContext.newInstance(MeeSevaInfo.class);
            final Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            final String tempvar =
            // "<RESULT
            // xmlns=\"http://tempuri.org/\"><ERRORCODE>1</ERRORCODE><MESSAGE>checksum</MESSAGE><TRANSID></TRANSID></RESULT>";
            messageElement[0].toString();
            if (LOGGER.isInfoEnabled())
                LOGGER.info("tempvar said: " + tempvar);
            final MeeSevaInfo a = buildMeesevaInfo(unmarshaller, tempvar);

            if (LOGGER.isInfoEnabled())
                LOGGER.info("result said: " + a.getMessage());
            // Second webservice call.

            final String[] arrPaymentDetails1 = new String[12];

            arrPaymentDetails1[0] = "CCSP01AKT1";
            arrPaymentDetails1[1] = "01";
            arrPaymentDetails1[2] = "CA";
            arrPaymentDetails1[3] = "APO-ADI-AKT-1";
            arrPaymentDetails1[4] = "APO-ADI-AKT";
            arrPaymentDetails1[5] = "PTIS-001-234";
            arrPaymentDetails1[6] = "059292c9e2d";
            arrPaymentDetails1[7] = "3016";
            arrPaymentDetails1[8] = "DEPTTRAN1";
            arrPaymentDetails1[9] = "00";
            arrPaymentDetails1[10] = "APONLINE";
            arrPaymentDetails1[11] = "9";

            final String[] arrTransParams1 = new String[9];
            arrTransParams1[0] = "Applicant Name";
            arrTransParams1[1] = "District";
            arrTransParams1[2] = "Mandal";
            arrTransParams1[3] = "Village";
            arrTransParams1[4] = "SLA";
            arrTransParams1[5] = "DeliveryType";
            arrTransParams1[6] = "TotalAmount";
            arrTransParams1[7] = "Status";
            arrTransParams1[8] = "SLAEnddate";

            final String[] arrTransDetails1 = new String[9];

            arrTransDetails1[0] = "Applicant Name";
            arrTransDetails1[1] = "112";
            arrTransDetails1[2] = "50004";
            arrTransDetails1[3] = "50004";
            arrTransDetails1[4] = "15";
            arrTransDetails1[5] = "MANUAL";
            arrTransDetails1[6] = "100";
            arrTransDetails1[7] = "0";
            arrTransDetails1[8] = "15/11/2015";

            final GetPaymentTransIdResponseGetPaymentTransIdResult response1 = serviceProxy
                    .getPaymentTransId(arrPaymentDetails1, arrAmount,
                            arrTransParams1, arrTransDetails1, "MEESEVA",
                            "MEESEVA", checksumForPaymTransId);

            final MessageElement[] messageElement1 = response1.get_any();

            final String tempvar1 =
            // <RESULT
            // xmlns=""><APPLICATIONNO/><ERRORCODE>5</ERRORCODE><TRANSID>RequestDetails
            // array length is less than 12</TRANSID></RESULT>
            messageElement1[0].toString();
            if (LOGGER.isInfoEnabled())
                LOGGER.info("result said: " + tempvar1);
            final MeeSevaInfo b = buildMeesevaInfo(unmarshaller, tempvar1);

            if (LOGGER.isInfoEnabled())
                LOGGER.info("result said: " + b.getErrorCode());

            if (LOGGER.isInfoEnabled())
                LOGGER.info("Call Web Service Operation...");

            /*
             * MeeSevaWebService meeSevaWebService= new MeeSevaWebService(); String tests =
             * meeSevaWebService.getPaymentTransId(arrPaymentDetails, arrAmount, arrTransParams, arrTransDetails, "MEESEVA",
             * "MEESEVA", checksumForPaymTransId); System.out.println("tests " +tests);
             */
            if (LOGGER.isInfoEnabled())
                LOGGER.info("Create Web Service...");

            final String thirdpartychecksum = checkSumService.generateCheckSumUpdate("PTIS01-00016-10112015-50001", "03", "ssss");
            if (LOGGER.isInfoEnabled())
                LOGGER.info("*********************** thirdpartychecksum : " + thirdpartychecksum);
            final UpdateApplicationDetailsResponseUpdateApplicationDetailsResult thirdapiresponse = serviceProxy
                    .updateApplicationDetails("PTIS01-00016-10112015-50001", "03", "STILL IN PROGRESS", "ssss", "MEESEVA",
                            "MEESEVA", "9", thirdpartychecksum);
            final MessageElement[] messageElement2 = thirdapiresponse.get_any();

            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("result said: " + messageElement2[0].toString());
                LOGGER.info("***********************");
                LOGGER.info("Call Over!");
            }
        } catch (final ExceptionInInitializerError ex) {
            ex.printStackTrace();
            LOGGER.error("error in ExceptionInInitializerError"
                    + ex.getMessage());
        } catch (final Exception ex) {
            ex.printStackTrace();
            LOGGER.error("error in Exception" + ex.getMessage());
        }
    }

    private static MeeSevaInfo buildMeesevaInfo(
            final Unmarshaller unmarshaller, final String tempvar)
                    throws JAXBException {
        final MeeSevaInfo a = (MeeSevaInfo) unmarshaller.unmarshal(new StringReader(tempvar));
        return a;
    }

    private static Date getSlaEndDate(final int long1) {
        final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

        try {
            final Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.DATE, long1); // add 10 days

            return sdf.parse(sdf.format(cal.getTime()));
        } catch (final ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
}
