/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.utils.constants;

import java.util.HashMap;
import java.util.Map;

import org.egov.ptis.constants.PropertyTaxConstants;

public class MeesevaConstants {
    public static final String MODULE_NAME = "Meeseva";
    public static final String TRANSACTIONSTATUSOPEN = "03";
    public static final String TRANSACTIONSTATUSNOTVIEWED = "02";
    public static final String LOCAL = "LOCAL";
    public static final String NONLOCAL = "NONLOCAL";
    public static final String SERVICEAMOUNT = "SERVICEAMOUNT";
    public static final String USERCHARGES = "USERCHARGES";
    public static final String POSTALCHARGES_LOCAL = "POSTALCHARGES-LOCAL";
    public static final String POSTALCHARGES_NONLOCAL = "POSTALCHARGES-NONLOCAL";
    public static final String CHALLANAMOUNT = "CHALLANAMOUNT";
    public static final String PRINTCHARGES = "PRINTCHARGES";

    public static final String APPLICATION_STATUS_OPEN = "OPEN";
    public static final String APPLICATION_STATUS_APPROVED = "APPROVED";
    public static final String APPLICATION_STATUS_REJECTED = "REJECTED";

    public static final String MEESEVA_STATUS_OPEN = "03";
    public static final String MEESEVA_STATUS_APPROVED = "04";
    public static final String MEESEVA_STATUS_REJECTED = "05";

    public static final String SERVICE_TYPE_PAYMUTATIONFEE = "PT07";
    public static final String SERVICE_TYPE_NEW_ASSESSENT = "PT01";
    public static final String SERVICE_TYPE_TRANSFER_OF_TITLE_SELLER_AND_BUYER = "PT02";
    public static final String SERVICE_TYPE_TRANSFER_OF_TITLE_EITHER_SELLER_OR_BUYER = "PT03";
    public static final String SERVICE_TYPE_SUB_DIVISION_REQUEST = "PT04";
    public static final String SERVICE_TYPE_EXEMTION = "PT05";
    public static final String SERVICE_TYPE_VACANCY_REMISSION = "PT06";
    public static final String SERVICE_TYPE_APPLYING_FOR_TRADE_LICENSE = "APPLYING FOR TRADE LICENSE";
    public static final String SERVICE_TYPE_RENEWAL_OF_TRADE_LICENSE = "RENEWAL OF TRADE LICENSE";
    public static final String SERVICE_TYPE_WATER_TAB_CONNECTION = "NEW WATER TAB CONNECTION";
    public static final String SERVICE_TYPE_APPLYING_FOR_BUILDING_PERMISSION = "APPLYING FOR BUILDING PERMISSION";
    public static final String WATERTAXSERVICECODEPREFIX="WT";
    public static final String PROPERTYTAXSERVICECODEPREFIX="PT";
    public static final String APPLICATIONNUMBERULBCODEPREFIX="UC";
    public static final String SERVICE_TYPE_REVISION_PETITION = "PT08";
    public static final String SERVICE_TYPE_GENERAL_REVISION_PETITION = "PT09";
    
    
    public static final Map<String, String> SERVICE_TYPE_APPLICATION_TYPE_MAP = new HashMap<String, String>() {
        private static final long serialVersionUID = -3535603410144487232L;

        {
            put(SERVICE_TYPE_NEW_ASSESSENT, PropertyTaxConstants.APPLICATION_TYPE_NEW_ASSESSENT);
            put(SERVICE_TYPE_SUB_DIVISION_REQUEST, PropertyTaxConstants.APPLICATION_TYPE_BIFURCATE_ASSESSENT);
            put(SERVICE_TYPE_TRANSFER_OF_TITLE_SELLER_AND_BUYER, PropertyTaxConstants.APPLICATION_TYPE_TRANSFER_OF_OWNERSHIP);
            put(SERVICE_TYPE_TRANSFER_OF_TITLE_EITHER_SELLER_OR_BUYER,
                    PropertyTaxConstants.APPLICATION_TYPE_TRANSFER_OF_OWNERSHIP);
            put(SERVICE_TYPE_EXEMTION, PropertyTaxConstants.APPLICATION_TYPE_TAX_EXEMTION);
            put(SERVICE_TYPE_VACANCY_REMISSION, PropertyTaxConstants.APPLICATION_TYPE_VACANCY_REMISSION);
            put(SERVICE_TYPE_REVISION_PETITION, PropertyTaxConstants.APPLICATION_TYPE_REVISION_PETITION);
            put(SERVICE_TYPE_GENERAL_REVISION_PETITION, PropertyTaxConstants.APPLICATION_TYPE_GRP);

        }
    };

    public static final Map<String, String> APPLICATION_STATUS_MEESEVA_STATUS_MAP = new HashMap<String, String>() {
        private static final long serialVersionUID = -1110011797671557753L;

        {
            put(APPLICATION_STATUS_OPEN, MEESEVA_STATUS_OPEN);
            put(APPLICATION_STATUS_APPROVED, MEESEVA_STATUS_APPROVED);
            put(APPLICATION_STATUS_REJECTED, MEESEVA_STATUS_REJECTED);

        }
    };

}
