/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
 * accountability and the service delivery of the government  organizations.
 * <p>
 * Copyright (C) <2015>  eGovernments Foundation
 * <p>
 * The updated version of eGov suite of products as by eGovernments Foundation
 * is available at http://www.egovernments.org
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/ or
 * http://www.gnu.org/licenses/gpl.html .
 * <p>
 * In addition to the terms of the GPL license to be adhered to in using this
 * program, the following additional terms are to be complied with:
 * <p>
 * 1) All versions of this program, verbatim or modified must carry this
 * Legal Notice.
 * <p>
 * 2) Any misrepresentation of the origin of the material is prohibited. It
 * is required that all modified versions of this material be marked in
 * reasonable ways as different from the original version.
 * <p>
 * 3) This license does not grant any rights to any user of the program
 * with regards to rights under trademark law for use of the trade names
 * or trademarks of eGovernments Foundation.
 * <p>
 * In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.transactions.service;

import org.egov.meeseva.masters.entity.Charges;
import org.egov.meeseva.masters.service.ChargesService;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.repository.TransactionRequestRepository;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.service.property.PropertyThirdPartyService;
import org.egov.wtms.integration.WaterChargesThirdPartyService;
import org.joda.time.DateTimeConstants;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional(readOnly = true)
public class TransactionRequestService {

    private final TransactionRequestRepository transactionRequestRepository;

    @Autowired
    private ChargesService chargesService;

    @Autowired
    private MeeSevaWebService meeSevaWebService;

    @Autowired
    private PropertyThirdPartyService propertyThirdPartyService;

    @Autowired
    private WaterChargesThirdPartyService waterChargesThirdPartyService;

    @Autowired
    public TransactionRequestService(final TransactionRequestRepository transactionRequestRepository) {
        this.transactionRequestRepository = transactionRequestRepository;
    }

    public static Date getSlaEndDate(int workdays) {
        LocalDate date = new LocalDate();
        if (workdays < 1) {
            return date.toDate();
        }

        LocalDate result = date;
        int addedDays = 0;
        while (addedDays < workdays) {// EXCLUDE SATURDAY AND SUNDAY FROM NUMBER
            // OF DAYS TO BE CONSIDERED.
            result = result.plusDays(1);
            if (!(/* result.getDayOfWeek() == DateTimeConstants.SATURDAY || */result
                    .getDayOfWeek() == DateTimeConstants.SUNDAY)) {
                ++addedDays;
            }
        }

        return result.toDate();

    }

    @Transactional
    public void create(final TransactionRequest request) {
        transactionRequestRepository.saveAndFlush(request);
    }

    @Transactional
    public void update(final TransactionRequest request) {
        transactionRequestRepository.saveAndFlush(request);
    }

    @Transactional
    public void remove(final TransactionRequest request) {
        transactionRequestRepository.delete(request);
    }

    public TransactionRequest getRequestById(final Long requestId) {
        return transactionRequestRepository.findOne(requestId);
    }

    public TransactionRequest getRequestByUniqueNo(final String uniqueNo) {
        return transactionRequestRepository.findByUniqueNo(uniqueNo);
    }

    public TransactionRequest getRequestByMeesevaRequestNo(final String meesevaRequestNo) {
        return transactionRequestRepository.findByMeesevaRequestNo(meesevaRequestNo);
    }

    public TransactionRequest getRequestByMeesevaApplicationNo(final String applicationNo) {
        return transactionRequestRepository.findByApplicationNo(applicationNo);
    }

    public TransactionRequest getRequestByTransactionServiceNumber(final String serviceNumber) {
        return transactionRequestRepository.getRequestByTransactionServiceNumber(serviceNumber);
    }

    public void updatePaymentDetailsByApplicationNo(final String applicationNo, final PaymentDetails paymentDetails) {
        final TransactionRequest request = transactionRequestRepository.findByApplicationNo(applicationNo);
        request.setPaymentDetails(paymentDetails);
        update(request);
    }

    public TransactionRequest updateChargesByServiceAndDeliveryType(final String deliveryType,
                                                                    final TransactionRequest transactionRequest) {
        final List<Charges> chargesList = chargesService.getListOfChargesByServiceId(transactionRequest.getPaymentDetails()
                .getTransactionRequestId().getServiceId().getId());
        double totalAmount = 0;
        for (final Charges charges : chargesList) {
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.SERVICEAMOUNT)) {
                transactionRequest.getPaymentDetails().setServiceAmount(charges.getValue());
                totalAmount = totalAmount + charges.getValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.USERCHARGES)) {
                transactionRequest.getPaymentDetails().setUserCharges(charges.getValue());
                totalAmount = totalAmount + charges.getValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.POSTALCHARGES_LOCAL))
                if (deliveryType.equalsIgnoreCase(MeesevaConstants.LOCAL)) {
                    transactionRequest.getPaymentDetails().setPostalCharges(charges.getValue());
                    totalAmount = totalAmount + charges.getValue();
                }
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.POSTALCHARGES_NONLOCAL))
                if (deliveryType.equalsIgnoreCase(MeesevaConstants.NONLOCAL)) {
                    transactionRequest.getPaymentDetails().setPostalCharges(charges.getValue());
                    totalAmount = totalAmount + charges.getValue();
                }
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.CHALLANAMOUNT)) {
                transactionRequest.getPaymentDetails().setChallanAmount(charges.getValue());
                totalAmount = totalAmount + charges.getValue();
            }
            if (charges.getType().toUpperCase().equalsIgnoreCase(MeesevaConstants.PRINTCHARGES)) {
                transactionRequest.getPaymentDetails().setPrintCharges(charges.getValue());
                totalAmount = totalAmount + charges.getValue();
            }
        }
        transactionRequest.getPaymentDetails().setTotalAmount(totalAmount);
        return transactionRequest;
    }

    public void updatePaymentDetailsToMeeSeva(final Integer count) {
        final List<TransactionRequest> requestList = getRequestsToUpdatePayDetlToMeeSeva(count);
        for (final TransactionRequest request : requestList) {
            final String paymentGateWayResponse = meeSevaWebService.getPaymentTransId(request);
            buildTransactionRequestOnPaymentUpdate(request, paymentGateWayResponse);
            update(request);
        }
    }

    public void updateTransactionStatus(final Integer count) {
        final List<TransactionRequest> requestList = getRequestsToUpdateStatus(count);
        Map<String, String> statusCommentsMap = new HashMap<String, String>();
        for (final TransactionRequest request : requestList)
            if (request.getServiceId().getCode().contains(MeesevaConstants.PROPERTYTAXSERVICECODEPREFIX)) {

                if (request.getServiceId().getCode().equalsIgnoreCase(MeesevaConstants.SERVICE_TYPE_PAYMUTATIONFEE)) {
                    if (request.getPaymentDetails().getReceiptNumber() != null) {
                        statusCommentsMap.put("status", "Approved");
                        statusCommentsMap.put("updatedBy", "NA");
                        statusCommentsMap.put("comments", "NA");
                    } else {
                        statusCommentsMap.put("status", "Open");
                        statusCommentsMap.put("updatedBy", "NA");
                        statusCommentsMap.put("comments", "NA");
                    }

                } else {

                    statusCommentsMap = propertyThirdPartyService.validatePropertyStatus(
                            request.getPaymentDetails().getTransactionServiceNumber(),
                            MeesevaConstants.SERVICE_TYPE_APPLICATION_TYPE_MAP.get(request.getServiceId().getCode()));
                }

                if (statusCommentsMap.get("status") != null
                        && !statusCommentsMap.get("status").equalsIgnoreCase(MeesevaConstants.APPLICATION_STATUS_OPEN)) {
                    final boolean response = meeSevaWebService.UpdateApplicationDetails(request,
                            statusCommentsMap.get("updatedBy"),
                            MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(statusCommentsMap.get("status")
                                    .toUpperCase()),
                            statusCommentsMap.get("comments"));
                    if (response)
                        updateRequestStatus(request, statusCommentsMap);
                }
            } else if (request.getServiceId().getCode().contains(MeesevaConstants.WATERTAXSERVICECODEPREFIX)) {
                statusCommentsMap = waterChargesThirdPartyService.validateWaterConnectionStatus(
                        request.getPaymentDetails().getTransactionServiceNumber());
                if (statusCommentsMap.get("status") != null
                        && !statusCommentsMap.get("status").equalsIgnoreCase(MeesevaConstants.APPLICATION_STATUS_OPEN)) {
                    final boolean response = meeSevaWebService.UpdateApplicationDetails(request,
                            statusCommentsMap.get("updatedBy"),
                            MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(statusCommentsMap.get("status")
                                    .toUpperCase()),
                            statusCommentsMap.get("comments"));
                    if (response)
                        updateRequestStatus(request, statusCommentsMap);
                }
            }
    }

    public void updateRequestStatus(final TransactionRequest request, final Map<String, String> statusCommentsMap) {
        request.setTransactionStatus(MeesevaConstants.APPLICATION_STATUS_MEESEVA_STATUS_MAP.get(statusCommentsMap.get("status")
                .toUpperCase()));
        request.setStatusUpdateRemarks(statusCommentsMap.get("comments"));
        request.setStatusUpdated(true);
        request.setHistory(true);
        update(request);
    }

 /*   private Date getSlaEndDate(final int long1) {
        final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

        try {
            final Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.DATE, long1); // add 10 days

            return sdf.parse(sdf.format(cal.getTime()));
        } catch (final ParseException e) {
            e.printStackTrace();
        }
        return null;
    }*/

    public void buildTransactionRequestOnPaymentUpdate(final TransactionRequest meeSevaTransactionRequest,
                                                       final String paymentGateWayResponse) {

        if (paymentGateWayResponse != null) {
            meeSevaTransactionRequest.setMeesevaTransactionId(paymentGateWayResponse);
            meeSevaTransactionRequest.setPaymentUpdated(true);
            if (meeSevaTransactionRequest.getTransactionStatus() == null
                    || meeSevaTransactionRequest.getTransactionStatus().equalsIgnoreCase("0")
                    || meeSevaTransactionRequest.getTransactionStatus().equalsIgnoreCase(MeesevaConstants.TRANSACTIONSTATUSNOTVIEWED))
                meeSevaTransactionRequest.setTransactionStatus(MeesevaConstants.TRANSACTIONSTATUSOPEN);
        }
        if (meeSevaTransactionRequest.getServiceId().getSla() != null
                && meeSevaTransactionRequest.getPaymentDetails().getSlaEndDate() == null) {
            final Date cal = getSlaEndDate(meeSevaTransactionRequest.getServiceId().getSla().intValue());
            if (cal != null)
                meeSevaTransactionRequest.getPaymentDetails().setSlaEndDate(cal);
        }
    }

    public List<TransactionRequest> getRequestsToUpdatePayDetlToMeeSeva(final Integer count) {
        if (count != null && count > 0)
            return transactionRequestRepository.getRequestsToUpdatePayDetlToMeeSeva(new PageRequest(0, count));
        else
            return transactionRequestRepository.getRequestsToUpdatePayDetlToMeeSeva();

    }

    public List<TransactionRequest> getRequestsToUpdateStatus(final Integer count) {
        if (count != null && count > 0)
            return transactionRequestRepository.getRequestsToUpdateStatus(new PageRequest(0, count),
                    MeesevaConstants.MEESEVA_STATUS_OPEN);
        else
            return transactionRequestRepository.getRequestsToUpdateStatus(MeesevaConstants.MEESEVA_STATUS_OPEN);

    }

    public boolean validateRequestByApplicationNo(final String applicationNo) {
        final TransactionRequest request = getRequestByMeesevaApplicationNo(applicationNo);
        if (request.getPaymentDetails().getTransactionServiceId() != null)
            return false;
        else
            return true;

    }

}
