/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.transactions.entity;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.meeseva.masters.entity.Services;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name = "EGMEESEVA_TRANSACTIONREQUEST")
@SequenceGenerator(name = TransactionRequest.SEQ_TRANSACTIONREQUEST, sequenceName = TransactionRequest.SEQ_TRANSACTIONREQUEST, allocationSize = 1)
public class TransactionRequest extends AbstractAuditable {

    private static final long serialVersionUID = -8901978018968867770L;

    public static final String SEQ_TRANSACTIONREQUEST = "SEQ_EGMEESEVA_TRANSACTIONREQUEST";

    @Id
    @GeneratedValue(generator = SEQ_TRANSACTIONREQUEST, strategy = GenerationType.SEQUENCE)
    private Long id;

    @ManyToOne
    @JoinColumn(name = "serviceId")
    private Services serviceId;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "transactionRequestId")
    private PaymentDetails paymentDetails;

    @SafeHtml
    @Length(max = 50)
    private String applicationNo;

    @SafeHtml
    @Length(max = 50)
    private String meesevaRequestNo;

    @SafeHtml
    @Length(max = 50)
    private String uniqueNo;

    @SafeHtml
    @Length(max = 50)
    private String scaUserId;

    @SafeHtml
    @Length(max = 50)
    private String channelId;

    @SafeHtml
    @Length(max = 50)
    private String requestId;

    @SafeHtml
    @Length(max = 50)
    private String operaterId;

    @SafeHtml
    @Length(max = 50)
    private String scaPassword;

    @SafeHtml
    @Length(max = 50)
    private String organizationflag;

    @SafeHtml
    @Length(max = 50)
    private String meesevaTransactionId;

    private boolean paymentConfirmStatus;

    private boolean paymentUpdated;

    private boolean statusUpdated;

    @SafeHtml
    @Length(max = 10)
    private String transactionStatus;

    @SafeHtml
    @Length(max = 250)
    private String statusUpdateRemarks;

    private boolean isHistory;

    /* @Override */
    @Override
    public Long getId() {
        return id;
    }

    /* @Override */
    @Override
    public void setId(final Long id) {
        this.id = id;
    }

    public Services getServiceId() {
        return serviceId;
    }

    public void setServiceId(final Services serviceId) {
        this.serviceId = serviceId;
    }

    public String getApplicationNo() {
        return applicationNo;
    }

    public void setApplicationNo(final String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getMeesevaRequestNo() {
        return meesevaRequestNo;
    }

    public void setMeesevaRequestNo(final String meesevaRequestNo) {
        this.meesevaRequestNo = meesevaRequestNo;
    }

    public String getUniqueNo() {
        return uniqueNo;
    }

    public void setUniqueNo(final String uniqueNo) {
        this.uniqueNo = uniqueNo;
    }

    public String getScaUserId() {
        return scaUserId;
    }

    public void setScaUserId(final String scaUserId) {
        this.scaUserId = scaUserId;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(final String channelId) {
        this.channelId = channelId;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(final String requestId) {
        this.requestId = requestId;
    }

    public String getOperaterId() {
        return operaterId;
    }

    public void setOperaterId(final String operaterId) {
        this.operaterId = operaterId;
    }

    public String getScaPassword() {
        return scaPassword;
    }

    public void setScaPassword(final String scaPassword) {
        this.scaPassword = scaPassword;
    }

    public String getOrganizationflag() {
        return organizationflag;
    }

    public void setOrganizationflag(final String organizationflag) {
        this.organizationflag = organizationflag;
    }

    public String getMeesevaTransactionId() {
        return meesevaTransactionId;
    }

    public void setMeesevaTransactionId(final String meesevaTransactionId) {
        this.meesevaTransactionId = meesevaTransactionId;
    }

    public boolean isPaymentConfirmStatus() {
        return paymentConfirmStatus;
    }

    public void setPaymentConfirmStatus(final boolean paymentConfirmStatus) {
        this.paymentConfirmStatus = paymentConfirmStatus;
    }

    public boolean isPaymentUpdated() {
        return paymentUpdated;
    }

    public void setPaymentUpdated(final boolean paymentUpdated) {
        this.paymentUpdated = paymentUpdated;
    }

    public boolean isStatusUpdated() {
        return statusUpdated;
    }

    public void setStatusUpdated(final boolean statusUpdated) {
        this.statusUpdated = statusUpdated;
    }

    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(final String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getStatusUpdateRemarks() {
        return statusUpdateRemarks;
    }

    public void setStatusUpdateRemarks(final String statusUpdateRemarks) {
        this.statusUpdateRemarks = statusUpdateRemarks;
    }

    public boolean isHistory() {
        return isHistory;
    }

    public void setHistory(final boolean isHistory) {
        this.isHistory = isHistory;
    }

    public PaymentDetails getPaymentDetails() {
        return paymentDetails;
    }

    public void setPaymentDetails(final PaymentDetails paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

}
