/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.transactions.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name = "EGMEESEVA_PAYMENTDETAILS")
@SequenceGenerator(name = PaymentDetails.SEQ_PAYMENTDETAILS, sequenceName = PaymentDetails.SEQ_PAYMENTDETAILS, allocationSize = 1)
public class PaymentDetails extends AbstractAuditable {

    private static final long serialVersionUID = -424949858071366353L;

    public static final String SEQ_PAYMENTDETAILS = "SEQ_EGMEESEVA_PAYMENTDETAILS";

    @Id
    @GeneratedValue(generator = SEQ_PAYMENTDETAILS, strategy = GenerationType.SEQUENCE)
    private Long id;

    @OneToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "transactionRequestId")
    private TransactionRequest transactionRequestId;

    @SafeHtml
    @Length(max = 50)
    private String applicantName;

    @SafeHtml
    @Length(max = 250)
    private String applicantAddress;

    @SafeHtml
    @Length(max = 50)
    private String districtid;

    @SafeHtml
    @Length(max = 50)
    private String municipalCode;

    @SafeHtml
    @Length(max = 10)
    private String mobileNo;

    private Double totalAmount = 0.0;

    private Double serviceAmount = 0.0;

    private Double userCharges = 0.0;

    private Double postalCharges = 0.0;

    private Double challanAmount = 0.0;

    private Double printCharges = 0.0;

    private Date slaEndDate;

    @SafeHtml
    @Length(max = 50)
    private String deliveryType;

    private Long transactionServiceId;

    @Length(max = 50)
    private String transactionServiceNumber;

    @SafeHtml
    @Length(max = 50)
    private String receiptNumber;

    @Temporal(TemporalType.TIMESTAMP)
    private Date receiptDate;

    private boolean applicantDetailsUpdated;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(final Long id) {
        this.id = id;
    }

    public TransactionRequest getTransactionRequestId() {
        return transactionRequestId;
    }

    public void setTransactionRequestId(final TransactionRequest transactionRequestId) {
        this.transactionRequestId = transactionRequestId;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(final String applicantName) {
        this.applicantName = applicantName;
    }

    public String getDistrictid() {
        return districtid;
    }

    public void setDistrictid(final String districtid) {
        this.districtid = districtid;
    }

    public String getMunicipalCode() {
        return municipalCode;
    }

    public void setMunicipalCode(final String municipalCode) {
        this.municipalCode = municipalCode;
    }

    public String getMobileNo() {
        return mobileNo;
    }

    public void setMobileNo(final String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(final Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Double getServiceAmount() {
        return serviceAmount;
    }

    public void setServiceAmount(final Double serviceAmount) {
        this.serviceAmount = serviceAmount;
    }

    public Double getUserCharges() {
        return userCharges;
    }

    public void setUserCharges(final Double userCharges) {
        this.userCharges = userCharges;
    }

    public Double getPostalCharges() {
        return postalCharges;
    }

    public void setPostalCharges(final Double postalCharges) {
        this.postalCharges = postalCharges;
    }

    public Double getChallanAmount() {
        return challanAmount;
    }

    public void setChallanAmount(final Double challanAmount) {
        this.challanAmount = challanAmount;
    }

    public Double getPrintCharges() {
        return printCharges;
    }

    public void setPrintCharges(final Double printCharges) {
        this.printCharges = printCharges;
    }

    public Date getSlaEndDate() {
        return slaEndDate;
    }

    public void setSlaEndDate(final Date slaEndDate) {
        this.slaEndDate = slaEndDate;
    }

    public String getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(final String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Long getTransactionServiceId() {
        return transactionServiceId;
    }

    public void setTransactionServiceId(final Long transactionServiceId) {
        this.transactionServiceId = transactionServiceId;
    }

    public String getTransactionServiceNumber() {
        return transactionServiceNumber;
    }

    public void setTransactionServiceNumber(final String transactionServiceNumber) {
        this.transactionServiceNumber = transactionServiceNumber;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(final String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Date getReceiptDate() {
        return receiptDate;
    }

    public void setReceiptDate(final Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getApplicantAddress() {
        return applicantAddress;
    }

    public void setApplicantAddress(final String applicantAddress) {
        this.applicantAddress = applicantAddress;
    }

    public boolean isApplicantDetailsUpdated() {
        return applicantDetailsUpdated;
    }

    public void setApplicantDetailsUpdated(final boolean applicantDetailsUpdated) {
        this.applicantDetailsUpdated = applicantDetailsUpdated;
    }

}
