/* eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.security.spring.filter;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class EgovMeeSevaAuthenticationSuccessHandler extends SavedRequestAwareAuthenticationSuccessHandler {
	private static final Logger LOG = LoggerFactory.getLogger(EgovMeeSevaAuthenticationSuccessHandler.class);
    private final RequestCache requestCache = new HttpSessionRequestCache();
    public static final String MEESEVA_REDIRECT_URL = "/meesevaservices-redirect";

    public EgovMeeSevaAuthenticationSuccessHandler() {
    }

    public EgovMeeSevaAuthenticationSuccessHandler(final String defaultTargetUrl) {
        setDefaultTargetUrl(defaultTargetUrl);
    }

    @Override
    public void onAuthenticationSuccess(final HttpServletRequest request, final HttpServletResponse response,
            final Authentication authentication) throws ServletException, IOException {
        final SavedRequest savedRequest = requestCache.getRequest(request, response);

        final String redirectUrl = getDefaultTargetUrl();
        if (savedRequest == null)
            if (redirectUrl != null && redirectUrl.equals(MEESEVA_REDIRECT_URL) && request.getQueryString() != null) {
                getRedirectStrategy().sendRedirect(request, response, redirectUrl + "?" + request.getQueryString());
                return;
            } else {
                super.onAuthenticationSuccess(request, response, authentication);
                return;
            }

        final String targetUrlParameter = getTargetUrlParameter();
        if (isAlwaysUseDefaultTargetUrl()
                || targetUrlParameter != null && StringUtils.hasText(request
                        .getParameter(targetUrlParameter))) {
            requestCache.removeRequest(request, response);
            super.onAuthenticationSuccess(request, response, authentication);

            return;
        }

        clearAuthenticationAttributes(request);

        // Use the DefaultSavedRequest URL
        final String targetUrl = savedRequest.getRedirectUrl();
        if (LOG.isDebugEnabled())
        	LOG.debug("Redirecting to DefaultSavedRequest Url: " + targetUrl);
        if (redirectUrl != null && targetUrl.equals(MEESEVA_REDIRECT_URL) && request.getQueryString() != null)
            getRedirectStrategy().sendRedirect(request, response, targetUrl + "?" + request.getQueryString());
        else
            getRedirectStrategy().sendRedirect(request, response, targetUrl);

    }

}
