/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

	1) All versions of this program, verbatim or modified must carry this
	   Legal Notice.

	2) Any misrepresentation of the origin of the material is prohibited. It
	   is required that all modified versions of this material be marked in
	   reasonable ways as different from the original version.

	3) This license does not grant any rights to any user of the program
	   with regards to rights under trademark law for use of the trade names
	   or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.rest.service;

import java.util.HashMap;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;

import org.egov.meeseva.utils.DecryptionUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("checkSumService")
@Transactional(readOnly = true)
public class CheckSumService {

    public boolean validateMeeSevaRequest(final HttpServletRequest request) {

        HashMap<String, String> requestParms = new HashMap<String, String>();
        requestParms = decryptInitialServiceRequestParameters(request);
        if (validateCheckSum(requestParms.get("scaUserId"),
                requestParms.get("scaPassword"), requestParms.get("centerId"),
                requestParms.get("operatorId"), requestParms.get("uniqueNo"),
                requestParms.get("Checksum")))
            return true;
        else
            return false;
    }

    public HashMap<String, String> decryptInitialServiceRequestParameters(
            final HttpServletRequest request) {

        final HashMap<String, String> parms = new HashMap<String, String>();

        final byte[] myIV = { (byte) 50, (byte) 51, (byte) 52, (byte) 53, (byte) 54, (byte) 55, (byte) 56, (byte) 57 };
        final byte[] tdesKeyData = { (byte) 0xA2, (byte) 0x15, (byte) 0x37,
                (byte) 0x07, (byte) 0xCB, (byte) 0x62, (byte) 0xC1,
                (byte) 0xD3, (byte) 0xF8, (byte) 0xF1, (byte) 0x97,
                (byte) 0xDF, (byte) 0xD0, (byte) 0x13, (byte) 0x4F,
                (byte) 0x79, (byte) 0x01, (byte) 0x67, (byte) 0x7A,
                (byte) 0x85, (byte) 0x94, (byte) 0x16, (byte) 0x31,
                (byte) 0x92 };

        final DecryptionUtil objText = new DecryptionUtil(tdesKeyData, myIV);
        final String meesevaRequestCode = request.getParameter("enc");
        final String ulbCode = request.getParameter("ulbcode");
        final String distCode = request.getParameter("distcode");

        if (meesevaRequestCode != null) {
            String strURL = null;
            try {
                strURL = objText.decryptText(meesevaRequestCode);
            } catch (final Exception e) {
                e.printStackTrace();
            }
            if (strURL != null) {
                final String values[] = strURL.split("&");
                for (final String value : values) {
                    final String paramValues[] = value.split("=");
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P1"))
                        parms.put("uniqueNo", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P2")) {
                        parms.put("scaUserId", paramValues[1]);
                        parms.put("centerId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P3"))
                        parms.put("operatorId", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P4"))
                        parms.put("channelId", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P5"))
                        parms.put("Checksum", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P6"))
                        parms.put("requestId", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P7")) {
                        parms.put("serviceId", paramValues[1]);
                        parms.put("meesevaServiceId", paramValues[1]);
                    }
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P8"))
                        parms.put("scaPassword", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P9"))
                        parms.put("meesevaSequenceNumber", paramValues[1]);
                    if (paramValues != null && paramValues.length == 2 && paramValues[0].equals("P10"))
                        parms.put("flag", paramValues[1]);
                }
            }
        }
        parms.put("ulbcode", ulbCode);
        parms.put("distcode", distCode);
        return parms;
    }

    public boolean validateCheckSum(final String scaUserId,
            final String scaPassword, final String centerId,
            final String operatorId, final String uniqueNo,
            final String Checksum) {

        try {

            final String generatedChecksum = Checksum.substring(1,
                    Checksum.length() - 1);
            final String str1 = centerId + uniqueNo;
            final String str2 = operatorId;
            final String check3 = str1 + scaUserId + str2 + scaPassword;
            final Integer l1 = str1.length();
            final Integer l2 = str2.length();
            final String check1 = str1.substring(0, l1 - 3);
            final String check2 = str2.substring(0, l2 - 2);
            if (generatedChecksum.equals(check3 + check2 + uniqueNo + check1))
                return true;
            else
                return false;

        } catch (final Exception ex) {
            return false;
        }

    }

    public String generateCheckSum(final String scaUserId,
            final String scaPassword, final String centerId,
            final String operatorId, final String uniqueNo) {
        String checkSum = "";
        try {
            final String str1 = centerId + uniqueNo;
            final String str2 = operatorId;
            final String check3 = str1 + scaUserId + str2 + scaPassword;
            final Integer l1 = str1.length();
            final Integer l2 = str2.length();
            final String check1 = str1.substring(0, l1 - 3);
            final String check2 = str2.substring(0, l2 - 2);
            final Random random = new Random();
            final String check4 = ((Integer) random.nextInt(9)).toString();
            checkSum = check4 + check3 + check2 + uniqueNo + check1 + check4;
        } catch (final Exception ex) {

        }
        return checkSum;
    }

    public String generateCheckSumUpdate(final String appno,
            final String status, final String updatedby) {
        String checkSum = "";
        try {
            final String str1 = appno + status;
            final String str2 = updatedby;

            final Integer n1 = str1.length();
            final Integer n2 = str2.length();
            final String l1 = str1.substring(0, n1 - 3);
            final String l2 = str2.substring(0, n2 - 2);
            final Random random = new Random();
            final String l4 = ((Integer) random.nextInt(9)).toString();
            checkSum = l4 + l2 + l1 + l4;
        } catch (final Exception ex) {

        }
        return checkSum;
    }

	public HashMap<String, String> decryptPrintCertificateParameters(
			HttpServletRequest request) {

		final HashMap<String, String> parms = new HashMap<String, String>();

		final byte[] myIV = { (byte) 50, (byte) 51, (byte) 52, (byte) 53,
				(byte) 54, (byte) 55, (byte) 56, (byte) 57 };
		final byte[] tdesKeyData = { (byte) 0xA2, (byte) 0x15, (byte) 0x37,
				(byte) 0x07, (byte) 0xCB, (byte) 0x62, (byte) 0xC1,
				(byte) 0xD3, (byte) 0xF8, (byte) 0xF1, (byte) 0x97,
				(byte) 0xDF, (byte) 0xD0, (byte) 0x13, (byte) 0x4F,
				(byte) 0x79, (byte) 0x01, (byte) 0x67, (byte) 0x7A,
				(byte) 0x85, (byte) 0x94, (byte) 0x16, (byte) 0x31, (byte) 0x92 };

		final DecryptionUtil objText = new DecryptionUtil(tdesKeyData, myIV);

		if (request != null) {
			String strURL = null;
			try {
				strURL = objText.decryptText(request.getParameter("p1"));
			} catch (final Exception e) {
				e.printStackTrace();
			}
			if (strURL != null) {
				final String values[] = strURL.split("&");
				for (final String value : values) {
					final String paramValues[] = value.split("=");
					if (paramValues != null && paramValues.length == 2
							&& paramValues[0].equals("P1"))
						parms.put("applicationNumber", paramValues[1]);
					if (paramValues != null && paramValues.length == 2
							&& paramValues[0].equals("P2")) {
						parms.put("operatorId", paramValues[1]);
					}
				}
			}
		}

		return parms;
	}

}
