package org.egov.meeseva.config;

import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.egov.meeseva.scheduler.BulkPaymentUpdationJob;
import org.egov.meeseva.scheduler.BulkStatusUpdationJob;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

@Configuration
@Conditional(SchedulerConfigCondition.class)
public class MeesevaSchedulerConfiguration extends QuartzSchedulerConfiguration {

    @Bean
    public SchedulerFactoryBean meesevaScheduler(DataSource dataSource) {
        SchedulerFactoryBean meesevaScheduler = createScheduler(dataSource);
        meesevaScheduler.setSchedulerName("meeseva-scheduler");
        meesevaScheduler.setAutoStartup(true);
        meesevaScheduler.setOverwriteExistingJobs(true);
        meesevaScheduler.setTriggers(
                bulkPaymentUpdateCronTrigger().getObject(),
                bulkStatusUpdateCronTrigger().getObject());
        return meesevaScheduler;
    }

    @Bean("meesevaBulkPaymentUpdationJob")
    public BulkPaymentUpdationJob meesevaBulkPaymentUpdationJob() {
        BulkPaymentUpdationJob bulkPaymentUpdationJob = new BulkPaymentUpdationJob();
        bulkPaymentUpdationJob.setTransactionCount(100);
        return bulkPaymentUpdationJob;
    }

    @Bean
    public JobDetailFactoryBean bulkPaymentUpdateJobDetail() {
        JobDetailFactoryBean bulkPaymentUpdateJobDetail = new JobDetailFactoryBean();
        bulkPaymentUpdateJobDetail.setGroup("MEESEVA_JOB_GROUP");
        bulkPaymentUpdateJobDetail.setName("MEESEVA_BULK_PAYMENT_UPDATE_JOB");
        bulkPaymentUpdateJobDetail.setDurability(true);
        bulkPaymentUpdateJobDetail.setJobClass(BulkPaymentUpdationJob.class);
        bulkPaymentUpdateJobDetail.setRequestsRecovery(true);
        Map<String, String> jobDetailMap = new HashMap<>();
        jobDetailMap.put("jobBeanName", "meesevaBulkPaymentUpdationJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "false");
        jobDetailMap.put("moduleName", "meeseva");
        bulkPaymentUpdateJobDetail.setJobDataAsMap(jobDetailMap);
        return bulkPaymentUpdateJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean bulkPaymentUpdateCronTrigger() {
        CronTriggerFactoryBean bulkPaymentUpdateCron = new CronTriggerFactoryBean();
        bulkPaymentUpdateCron.setJobDetail(bulkPaymentUpdateJobDetail().getObject());
        bulkPaymentUpdateCron.setGroup("MEESEVA_TRIGGER_GROUP");
        bulkPaymentUpdateCron.setName("MEESEVA_BULK_PAYMENT_UPDATE_TRIGGER");
        bulkPaymentUpdateCron.setCronExpression("0 0/30 * * * ?");
        return bulkPaymentUpdateCron;
    }

    @Bean("meesevaBulkStatusUpdationJob")
    public BulkStatusUpdationJob meesevaBulkStatusUpdationJob() {
        BulkStatusUpdationJob meesevaBulkStatusUpdationJob = new BulkStatusUpdationJob();
        meesevaBulkStatusUpdationJob.setTransactionCount(100);
        return meesevaBulkStatusUpdationJob;
    }

    @Bean
    public JobDetailFactoryBean bulkStatusUpdateJobDetail() {
        JobDetailFactoryBean bulkStatusUpdateJobDetail = new JobDetailFactoryBean();
        bulkStatusUpdateJobDetail.setGroup("MEESEVA_JOB_GROUP");
        bulkStatusUpdateJobDetail.setName("MEESEVA_BULK_STATUS_UPDATE_JOB");
        bulkStatusUpdateJobDetail.setDurability(true);
        bulkStatusUpdateJobDetail.setJobClass(BulkStatusUpdationJob.class);
        bulkStatusUpdateJobDetail.setRequestsRecovery(true);
        Map<String, String> jobDetailMap = new HashMap<>();
        jobDetailMap.put("jobBeanName", "meesevaBulkStatusUpdationJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "false");
        jobDetailMap.put("moduleName", "meeseva");
        bulkStatusUpdateJobDetail.setJobDataAsMap(jobDetailMap);
        return bulkStatusUpdateJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean bulkStatusUpdateCronTrigger() {
        CronTriggerFactoryBean bulkStatusUpdateCron = new CronTriggerFactoryBean();
        bulkStatusUpdateCron.setJobDetail(bulkStatusUpdateJobDetail().getObject());
        bulkStatusUpdateCron.setGroup("MEESEVA_TRIGGER_GROUP");
        bulkStatusUpdateCron.setName("MEESEVA_BULK_STATUS_UPDATE_TRIGGER");
        bulkStatusUpdateCron.setCronExpression("0 0/30 13-15,19-23 * * ?");
        return bulkStatusUpdateCron;
    }
}
