/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.common.service;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.meeseva.masters.entity.Services;
import org.egov.meeseva.masters.service.MeeSevaServicesService;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("genericMeesevaService")
@Transactional(readOnly = true)
public class GenericMeesevaService {
    final static SimpleDateFormat sdf = new SimpleDateFormat("YYYY");
    private static final String APP_NUMBER_SEQ = "SEQ_EGMEESEVA_APPLICATIONNO_" + sdf.format(new Date());

    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;

    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Autowired
    private TransactionRequestService transactionRequestService;

    @Autowired
    private MeeSevaServicesService meeSevaServicesService;

    public boolean validateServiceRequest(final String sequenceNumber) {
        final TransactionRequest request = transactionRequestService
                .getRequestByMeesevaRequestNo(sequenceNumber);
        if (null != request)
            return false;
        else
            return true;
    }

    public boolean validateMeesevaServiceId(final String meesevaServiceId) {
        final Services service = meeSevaServicesService
                .getServiceByMeesevaServiceId(meesevaServiceId);

        if (null != service)
            return true;
        else
            return false;

    }

    private String generateApplicationNo(final String serviceCode,
            final String sequenceNumber, final Date toDay, final String ulbCode) {
        final SimpleDateFormat sdfr = new SimpleDateFormat("ddMMYYYY");
        return serviceCode + sequenceNumber + sdfr.format(toDay)
                + MeesevaConstants.APPLICATIONNUMBERULBCODEPREFIX + ulbCode;
    }

    public TransactionRequest persistMeesevaRequest(final HttpServletRequest request,
            final HashMap<String, String> requestParms) {
        String ulbCode = "", serviceCode = "";
        Serializable sequenceNumber;
        final Date toDay = new Date();

        final TransactionRequest meesevaReq = new TransactionRequest();
        final PaymentDetails paymentDetails = new PaymentDetails();
        meesevaReq.setPaymentDetails(paymentDetails);
        paymentDetails.setTransactionRequestId(meesevaReq);

        if (null != requestParms.get("scaUserId"))
            meesevaReq.setScaUserId(requestParms.get("scaUserId"));
        if (null != requestParms.get("scaPassword"))
            meesevaReq.setScaPassword(requestParms.get("scaPassword"));
        if (null != requestParms.get("operatorId"))
            meesevaReq.setOperaterId(requestParms.get("operatorId"));

        if (null != requestParms.get("channelId"))
            meesevaReq.setChannelId(requestParms.get("channelId"));

        if (null != requestParms.get("uniqueNo"))
            meesevaReq.setUniqueNo(requestParms.get("uniqueNo"));
        if (null != requestParms.get("requestId"))
            meesevaReq.setRequestId(requestParms.get("requestId"));
        if (null != requestParms.get("flag"))
            meesevaReq.setOrganizationflag(requestParms.get("flag"));
        if (null != requestParms.get("meesevaSequenceNumber"))
            meesevaReq.setMeesevaRequestNo(requestParms.get("meesevaSequenceNumber"));

        if (null != requestParms.get("serviceId")) {
            meesevaReq.setServiceId(meeSevaServicesService.getServiceByMeesevaServiceId(requestParms.get("serviceId")));
            serviceCode = meesevaReq.getServiceId().getCode();
        }
        if (null != requestParms.get("ulbcode")) {
            ulbCode = requestParms.get("ulbcode");
            meesevaReq.getPaymentDetails().setMunicipalCode(requestParms.get("ulbcode"));
        }
        if (null != requestParms.get("distcode"))
            meesevaReq.getPaymentDetails().setDistrictid(requestParms.get("distcode"));
        try {
            try {
                sequenceNumber = sequenceNumberGenerator
                        .getNextSequence(APP_NUMBER_SEQ);
            } catch (final SQLGrammarException e) {
                sequenceNumber = dbSequenceGenerator
                        .createAndGetNextSequence(APP_NUMBER_SEQ);
            }
        } catch (final SQLException e) {
            throw new ApplicationRuntimeException(
                    "Error occurred while generating Application Number", e);
        }
        sequenceNumber = String.format("%s%05d", "", sequenceNumber);
        meesevaReq.setApplicationNo(generateApplicationNo(serviceCode,
                sequenceNumber.toString(), toDay, ulbCode));

        meesevaReq.setPaymentDetails(paymentDetails);
        transactionRequestService.create(meesevaReq);
        return meesevaReq;
    }

    private String generateReceiptNumber() {
        final SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        final SimpleDateFormat sdf2 = new SimpleDateFormat("YYYY");
        final String strObj = "MEESEVA_RECEIPT_" + sdf2.format(new Date());
        Serializable sequenceNumber;
        try {
            try {
                sequenceNumber = sequenceNumberGenerator.getNextSequence(strObj);
            } catch (final SQLGrammarException e) {
                sequenceNumber = dbSequenceGenerator.createAndGetNextSequence(strObj);
            }
        } catch (final SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Application Number", e);
        }
        sequenceNumber = String.format("%s%04d", "", sequenceNumber);
        final String result = sdf1.format(new Date()) + '/' + sdf2.format(new Date()) + '/' + sequenceNumber;
        return result;
    }

    public TransactionRequest updateReceiptDetails(final TransactionRequest transactionRequest) {
        transactionRequest.getPaymentDetails().setReceiptNumber(generateReceiptNumber());
        transactionRequest.getPaymentDetails().setReceiptDate(new Date());
        return transactionRequest;
    }
}
