package org.egov.meeseva.aop;

import java.util.HashMap;

import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class VacancyRemissionAdvice {
	  private static final Logger LOGGER = Logger.getLogger(VacancyRemissionAdvice.class);

	    @Autowired
	    private MeeSevaWebService meeSevaWebService;

	    @Autowired
	    private TransactionRequestService transactionRequestService;

	    @Autowired
	    private GenericMeesevaService genericMeesevaService;

    @Pointcut("execution(*  org.egov.ptis.domain.service.property.VacancyRemissionService.saveVacancyRemission (..)) && args(vacancyRemission,approvalPosition,approvalComent,additionalRule,workFlowAction,propertyByEmployee,meesevaParams)")
    private void paymentGatewayPointcutForVacRemission( VacancyRemission vacancyRemission, Long approvalPosition,
             String approvalComent,  String additionalRule,  String workFlowAction, Boolean propertyByEmployee,HashMap<String, String> meesevaParams){}
    
   @Before(value="paymentGatewayPointcutForVacRemission(vacancyRemission,approvalPosition,approvalComent,additionalRule,workFlowAction,propertyByEmployee,meesevaParams)")
    public void getPaymentGatewayReponse( VacancyRemission vacancyRemission, Long approvalPosition,
            String approvalComent,  String additionalRule,  String workFlowAction, Boolean propertyByEmployee,HashMap<String, String> meesevaParams) {
        
	   final String applicationNumber = meesevaParams.get("APPLICATIONNUMBER");
        if (!transactionRequestService.validateRequestByApplicationNo(applicationNumber))
            throw new ApplicationRuntimeException("MEESEVA.002");
       // if (LOGGER.isDebugEnabled()) {
           System.out.println("applicationNumber ------------------- " + applicationNumber);
           System.out.println("vacancyRemission application number ------------- " +vacancyRemission.getApplicationNumber());
      //  }

        final TransactionRequest meeSevaTransactionRequest = transactionRequestService
                .getRequestByMeesevaApplicationNo(applicationNumber);

        final boolean paymentGateWayResponse = meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest);

        if (!paymentGateWayResponse)
            throw new ApplicationRuntimeException("MEESEVA.004");
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("paymentGateWayResponse " + paymentGateWayResponse);

        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(vacancyRemission.getApplicationNumber());
        transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("called before " + paymentGateWayResponse);
        
    } 
    
   @AfterReturning(pointcut="paymentGatewayPointcutForVacRemission(org.egov.ptis.domain.entity.property.VacancyRemission,java.lang.Long,java.lang.String,java.lang.String,java.lang.String,java.lang.Boolean,java.util.HashMap)",returning="retVal")
    public void getPaymentGatewayTransactionId(final Object retVal) {
       VacancyRemission vacancyRemission=(VacancyRemission)retVal;
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("vacancyRemission application number  after " + vacancyRemission.getApplicationNumber());

        final TransactionRequest meeSevaTransactionRequest = transactionRequestService
                .getRequestByTransactionServiceNumber(vacancyRemission.getApplicationNumber());

        if (meeSevaTransactionRequest != null) {
            if (LOGGER.isDebugEnabled())
                LOGGER.debug("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo());

            genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);

            final String paymentGateWayResponse = meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);

            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(vacancyRemission.getId());

            transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest,
                    paymentGateWayResponse);
            transactionRequestService.update(meeSevaTransactionRequest);

            if (LOGGER.isDebugEnabled())
                LOGGER.debug("called before " + paymentGateWayResponse);
        }
    }
}
