/**
 * eGov suite of products aim to improve the internal efficiency,transparency,
   accountability and the service delivery of the government  organizations.

    Copyright (C) <2015>  eGovernments Foundation

    The updated version of eGov suite of products as by eGovernments Foundation
    is available at http://www.egovernments.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see http://www.gnu.org/licenses/ or
    http://www.gnu.org/licenses/gpl.html .

    In addition to the terms of the GPL license to be adhered to in using this
    program, the following additional terms are to be complied with:

        1) All versions of this program, verbatim or modified must carry this
           Legal Notice.

        2) Any misrepresentation of the origin of the material is prohibited. It
           is required that all modified versions of this material be marked in
           reasonable ways as different from the original version.

        3) This license does not grant any rights to any user of the program
           with regards to rights under trademark law for use of the trade names
           or trademarks of eGovernments Foundation.

  In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.meeseva.aop;

import java.util.HashMap;

import org.apache.log4j.Logger;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RevisionPetitionAdvice {

    private static final Logger LOGGER = Logger.getLogger(ModifyPropertyAdvice.class);

    @Autowired
    private MeeSevaWebService meeSevaWebService;

    @Autowired
    private TransactionRequestService transactionRequestService;

    @Autowired
    private GenericMeesevaService genericMeesevaService;

    @Pointcut("execution(*  org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService.createRevisionPetition (..)) && args(objection,meesevaParams)")
    private void paymentGatewayPointcut(final RevisionPetition objection, final HashMap<String, String> meesevaParams) {
    }

    @Before(value = "paymentGatewayPointcut(objection,meesevaParams)")
    public void getPaymentGatewayReponse(final RevisionPetition objection, final HashMap<String, String> meesevaParams) {

        final String applicationNumber = (String) meesevaParams.get("APPLICATIONNUMBER");
        if (!transactionRequestService.validateRequestByApplicationNo(applicationNumber))
            throw new ApplicationRuntimeException("MEESEVA.002");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("applicationNumber " + applicationNumber);
        }

        final TransactionRequest meeSevaTransactionRequest = transactionRequestService
                .getRequestByMeesevaApplicationNo(applicationNumber);

        final boolean paymentGateWayResponse = meeSevaWebService.GetPaymentGatewayResponse(meeSevaTransactionRequest);

        if (!paymentGateWayResponse)
            throw new ApplicationRuntimeException("MEESEVA.004");
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("paymentGateWayResponse " + paymentGateWayResponse);

        meeSevaTransactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
        meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceNumber(objection.getObjectionNumber());
        transactionRequestService.update(meeSevaTransactionRequest);
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("called before " + paymentGateWayResponse);

    }

    @AfterReturning(pointcut = "paymentGatewayPointcut(org.egov.ptis.domain.entity.objection.RevisionPetition,java.util.HashMap)", returning = "retVal")
    public void getPaymentGatewayTransactionId(final Object retVal) {

        final RevisionPetition objection = (RevisionPetition) retVal;
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("basicProperty.getUpicNo()  after " + objection.getBasicProperty().getUpicNo() );

        final TransactionRequest meeSevaTransactionRequest = transactionRequestService
                .getRequestByTransactionServiceNumber(objection.getObjectionNumber());

        if (meeSevaTransactionRequest != null) {
            if (LOGGER.isDebugEnabled())
                LOGGER.debug("meeSevaTransactionRequest " + meeSevaTransactionRequest.getApplicationNo());

            genericMeesevaService.updateReceiptDetails(meeSevaTransactionRequest);

            final String paymentGateWayResponse = meeSevaWebService.getPaymentTransId(meeSevaTransactionRequest);

            meeSevaTransactionRequest.getPaymentDetails().setTransactionServiceId(objection.getId());

            transactionRequestService.buildTransactionRequestOnPaymentUpdate(meeSevaTransactionRequest,
                    paymentGateWayResponse);
            transactionRequestService.update(meeSevaTransactionRequest);

            if (LOGGER.isDebugEnabled())
                LOGGER.debug("called before " + paymentGateWayResponse);
        }

    }

}