CREATE TABLE egmeeseva_services (
    id bigint NOT NULL,
    name character varying(150),
    code character varying(20),
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_services
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY egmeeseva_services
    ADD CONSTRAINT pk_services PRIMARY KEY (id);


CREATE TABLE egmeeseva_charges (
    id bigint NOT NULL,
    serviceId bigint NOT NULL,
    serviceName character varying(150),
    serviceAmount double precision, 
    userCharges double precision,
    postalCharges double precision,
    challanAmount double precision,
    printCharges double precision,
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_charges
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY egmeeseva_charges
    ADD CONSTRAINT pk_charges PRIMARY KEY (id);
ALTER TABLE ONLY egmeeseva_charges
    ADD CONSTRAINT fk_service_charges FOREIGN KEY (serviceId) REFERENCES egmeeseva_services(id);

CREATE TABLE egmeeseva_transactionRequest (
    id bigint NOT NULL,
    uniqueNo character varying(50) NOT NULL,
    applicationNo character varying(50),
    userId bigint,
    scaId bigint,
    channelId bigint,
    requestId bigint,
    sourceId bigint,
    centerId bigint,
    operaterId bigint,
  	scaPassword character varying(50),
    ca character varying(50),
    checkSum character varying(150),
    version bigint
);
CREATE SEQUENCE seq_egmeeseva_transactionRequest
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE ONLY egmeeseva_transactionRequest
    ADD CONSTRAINT pk_transactionRequest PRIMARY KEY (id);

CREATE TABLE egmeeseva_transactionResponse (
    id bigint NOT NULL,
    applicationNo character varying(50),
    status character varying(50),
    remarks character varying(50),
    updatedBy bigint,
    userId bigint,
    password character varying(50),
    deptFlag character varying(50),
    checkSum character varying(150),
    version bigint
);

CREATE SEQUENCE seq_egmeeseva_transactionResponse
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER TABLE ONLY egmeeseva_transactionResponse
    ADD CONSTRAINT pk_transactionResponse PRIMARY KEY (id);
