/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.Appeal;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.service.JudgmentImplService;
import org.egov.lcms.transactions.service.JudgmentService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/judgmentimpl"})
public class JudgmentImplController {
    @Autowired
    private JudgmentImplService judgmentImplService;
    @Autowired
    private JudgmentService judgmentService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    private JudgmentImpl getJudgment(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) {
        Judgment judgment = this.judgmentService.findByLCNumber(lcNumber);
        if (judgment.getJudgmentImpl().isEmpty()) {
            JudgmentImpl judgemnetImpl = new JudgmentImpl();
            model.addAttribute("mode", (Object)"create");
            return judgemnetImpl;
        }
        model.addAttribute("mode", (Object)"edit");
        return (JudgmentImpl)judgment.getJudgmentImpl().get(0);
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="judgmentImpl") JudgmentImpl judgmentImpl, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        Judgment judgment = this.judgmentService.findByLCNumber(lcNumber);
        judgmentImpl = this.getJudgment(lcNumber, request, model);
        model.addAttribute("legalCase", (Object)judgment.getLegalCase());
        model.addAttribute("judgment", (Object)judgment);
        model.addAttribute("judgmentImpl", (Object)judgmentImpl);
        if (!judgmentImpl.getAppeal().isEmpty()) {
            JudgmentImpl newjudgmentImpl = this.getAppealDocuments(judgmentImpl);
            model.addAttribute("judgmentImpl", (Object)newjudgmentImpl);
        }
        return "judgmentimpl-new";
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="judgmentImpl") JudgmentImpl judgmentImpl, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files, Model model) throws IOException, ParseException {
        Judgment judgment = this.judgmentService.findByLCNumber(lcNumber);
        if (errors.hasErrors()) {
            model.addAttribute("judgment", (Object)judgment);
            model.addAttribute("legalCase", (Object)judgment.getLegalCase());
            return "judgmentimpl-new";
        }
        judgmentImpl.setJudgment(judgment);
        this.judgmentImplService.saveOrUpdate(judgmentImpl, files);
        if (judgmentImpl.getImplementationFailure() != null && judgmentImpl.getImplementationFailure().toString().equals("Appeal")) {
            JudgmentImpl newjudgmentImpl = this.getAppealDocuments(judgmentImpl);
            model.addAttribute("judgmentImpl", (Object)newjudgmentImpl);
        }
        model.addAttribute("mode", (Object)"view");
        redirectAttrs.addFlashAttribute("judgmentImpl", (Object)judgmentImpl);
        model.addAttribute("message", (Object)"Judgment Implementation Saved successfully.");
        return "judgmentimpl-success";
    }

    private JudgmentImpl getAppealDocuments(JudgmentImpl judgmentImpl) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.legalCaseUtil.getAppealDocumentList(judgmentImpl);
        ((Appeal)judgmentImpl.getAppeal().get(0)).setAppealDocuments(documentDetailsList);
        return judgmentImpl;
    }
}

