/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.JudgmentType;
import org.egov.lcms.masters.service.JudgmentTypeService;
import org.egov.lcms.web.adaptor.JudgmentTypeJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/judgmenttype"})
public class JudgmentTypeController {
    private static final String JUDGMENTTYPE_NEW = "judgmenttype-new";
    private static final String JUDGMENTTYPE_RESULT = "judgmenttype-result";
    private static final String JUDGMENTTYPE_EDIT = "judgmenttype-edit";
    private static final String JUDGMENTTYPE_VIEW = "judgmenttype-view";
    private static final String JUDGMENTTYPE_SEARCH = "judgmenttype-search";
    @Autowired
    private JudgmentTypeService judgmentTypeService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("judgmentType", (Object)new JudgmentType());
        return JUDGMENTTYPE_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute JudgmentType judgmentType, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return JUDGMENTTYPE_NEW;
        }
        this.judgmentTypeService.persist(judgmentType);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.judgmentType.success", null, null));
        return "redirect:/judgmenttype/result/" + judgmentType.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        JudgmentType judgmentType = this.judgmentTypeService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("judgmentType", (Object)judgmentType);
        return JUDGMENTTYPE_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute JudgmentType judgmentType, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return JUDGMENTTYPE_EDIT;
        }
        this.judgmentTypeService.persist(judgmentType);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.judgmentType.update", null, null));
        return "redirect:/judgmenttype/result/" + judgmentType.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        JudgmentType judgmentType = this.judgmentTypeService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("judgmentType", (Object)judgmentType);
        return JUDGMENTTYPE_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        JudgmentType judgmentType = this.judgmentTypeService.findOne(id);
        model.addAttribute("judgmentType", (Object)judgmentType);
        return JUDGMENTTYPE_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        JudgmentType judgmentType = new JudgmentType();
        this.prepareNewForm(model);
        model.addAttribute("judgmentType", (Object)judgmentType);
        return JUDGMENTTYPE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute JudgmentType judgmentType) {
        List searchResultList = this.judgmentTypeService.search(judgmentType);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(JudgmentType.class, (Object)new JudgmentTypeJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

