/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.GovernmentDepartment;
import org.egov.lcms.masters.service.GovernmentDepartmentService;
import org.egov.lcms.web.adaptor.GovernmentDepartmentJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/governmentdepartment"})
public class GovernmentDepartmentController {
    private static final String GOVERNMENTDEPARTMENT_NEW = "governmentdepartment-new";
    private static final String GOVERNMENTDEPARTMENT_RESULT = "governmentdepartment-result";
    private static final String GOVERNMENTDEPARTMENT_EDIT = "governmentdepartment-edit";
    private static final String GOVERNMENTDEPARTMENT_VIEW = "governmentdepartment-view";
    private static final String GOVERNMENTDEPARTMENT_SEARCH = "governmentdepartment-search";
    @Autowired
    private GovernmentDepartmentService governmentDepartmentService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("governmentDepartment", (Object)new GovernmentDepartment());
        return GOVERNMENTDEPARTMENT_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute GovernmentDepartment governmentDepartment, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return GOVERNMENTDEPARTMENT_NEW;
        }
        this.governmentDepartmentService.persist(governmentDepartment);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.governmentDepartment.success", null, null));
        return "redirect:/governmentdepartment/result/" + governmentDepartment.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        GovernmentDepartment governmentDepartment = this.governmentDepartmentService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("governmentDepartment", (Object)governmentDepartment);
        return GOVERNMENTDEPARTMENT_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute GovernmentDepartment governmentDepartment, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return GOVERNMENTDEPARTMENT_EDIT;
        }
        this.governmentDepartmentService.persist(governmentDepartment);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.governmentDepartment.update", null, null));
        return "redirect:/governmentdepartment/result/" + governmentDepartment.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        GovernmentDepartment governmentDepartment = this.governmentDepartmentService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("governmentDepartment", (Object)governmentDepartment);
        return GOVERNMENTDEPARTMENT_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        GovernmentDepartment governmentDepartment = this.governmentDepartmentService.findOne(id);
        model.addAttribute("governmentDepartment", (Object)governmentDepartment);
        return GOVERNMENTDEPARTMENT_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        GovernmentDepartment governmentDepartment = new GovernmentDepartment();
        this.prepareNewForm(model);
        model.addAttribute("governmentDepartment", (Object)governmentDepartment);
        return GOVERNMENTDEPARTMENT_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute GovernmentDepartment governmentDepartment) {
        List searchResultList = this.governmentDepartmentService.search(governmentDepartment);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(GovernmentDepartment.class, (Object)new GovernmentDepartmentJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

