/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.masters.service.InterimOrderService;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.service.LegalCaseInterimOrderService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lcinterimorder"})
public class ViewAndEditLegalCaseInterimOrderController {
    @Autowired
    private LegalCaseInterimOrderService legalCaseInterimOrderService;
    @Autowired
    private InterimOrderService interimOrderService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    public LegalCaseInterimOrder getLcInterimOrder(@PathVariable String lcInterimOrderId) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.legalCaseInterimOrderService.findById(Long.valueOf(Long.parseLong(lcInterimOrderId)));
        return legalCaseInterimOrder;
    }

    @RequestMapping(value={"/edit/{lcInterimOrderId}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="lcInterimOrderId") String lcInterimOrderId, Model model, HttpServletRequest request) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        model.addAttribute("interimOrders", (Object)this.interimOrderService.findAll());
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("legalCase", (Object)legalCaseInterimOrder.getLegalCase());
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        this.getLcInterimOrderDocuments(legalCaseInterimOrder);
        model.addAttribute("mode", (Object)"edit");
        return "lcinterimorder-edit";
    }

    @RequestMapping(value={"/edit/{lcInterimOrderId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="legalCaseInterimOrder") LegalCaseInterimOrder legalCaseInterimOrder, BindingResult errors, RedirectAttributes redirectAttrs, @PathVariable(value="lcInterimOrderId") String lcInterimOrderId, @RequestParam(value="file") MultipartFile[] files, Model model) throws IOException, ParseException {
        model.addAttribute("legalCase", (Object)legalCaseInterimOrder.getLegalCase());
        if (errors.hasErrors()) {
            model.addAttribute("interimOrders", (Object)this.interimOrderService.findAll());
            return "lcinterimorder-edit";
        }
        this.legalCaseInterimOrderService.persist(legalCaseInterimOrder, files);
        redirectAttrs.addFlashAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        this.getLcInterimOrderDocuments(legalCaseInterimOrder);
        model.addAttribute("message", (Object)"InterimOrder updated successfully.");
        model.addAttribute("mode", (Object)"view");
        return "lcinterimorder-success";
    }

    @RequestMapping(value={"/view/{lcInterimOrderId}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="lcInterimOrderId") String lcInterimOrderId, Model model) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        this.getLcInterimOrderDocuments(legalCaseInterimOrder);
        model.addAttribute("mode", (Object)"view");
        return "lcinterimorder-success";
    }

    private LegalCaseInterimOrder getLcInterimOrderDocuments(LegalCaseInterimOrder legalCaseInterimOrder) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.legalCaseUtil.getLcInterimOrderDocumentList(legalCaseInterimOrder);
        legalCaseInterimOrder.setLcInterimOrderDocuments(documentDetailsList);
        return legalCaseInterimOrder;
    }
}

