/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.EgwStatus;
import org.egov.infra.utils.JsonUtils;
import org.egov.lcms.masters.entity.JudgmentType;
import org.egov.lcms.masters.service.JudgmentTypeService;
import org.egov.lcms.reports.entity.LegalCommonReportResult;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.service.GenericSubReportService;
import org.egov.lcms.transactions.service.LegalCommonReportService;
import org.egov.lcms.transactions.service.SearchLegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.web.adaptor.GenericSubReportJsonAdaptor;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class GenericSubReportController
extends GenericLegalCaseController {
    @Autowired
    private JudgmentTypeService judgmentTypeService;
    @Autowired
    private SearchLegalCaseService searchLegalCaseService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private GenericSubReportService genericSubReportService;
    @Autowired
    private LegalCommonReportService legalCommonReportService;

    @ModelAttribute(value="judgmentTypeList")
    public List<JudgmentType> judgmentTypeList() {
        return this.judgmentTypeService.getActiveJudgementTypes();
    }

    @ModelAttribute(value="statusList")
    public List<EgwStatus> statusList() {
        return this.legalCaseUtil.getStatusForModule();
    }

    @ModelAttribute(value="reportStatusList")
    public List<ReportStatus> getReportStatusList() {
        return this.searchLegalCaseService.getReportStatus();
    }

    @ModelAttribute(value="aggregatedByList")
    public List<String> defaultersList() {
        ArrayList<String> aggregatedByList = new ArrayList<String>();
        aggregatedByList.add("Court Name");
        aggregatedByList.add("Court Type");
        aggregatedByList.add("Petition Type");
        aggregatedByList.add("Case Status");
        aggregatedByList.add("In charge officer");
        aggregatedByList.add("Judgment outcome");
        aggregatedByList.add("Case Category");
        return aggregatedByList;
    }

    @RequestMapping(value={"/genericSubReport"}, method={RequestMethod.GET})
    public String searchForm(Model model, @ModelAttribute LegalCommonReportResult legalSubReportResult) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("legalSubReportResult", (Object)legalSubReportResult);
        return "genericsub-form";
    }

    @RequestMapping(value={"/genericSubResult"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getGenerivSubReportResult(HttpServletRequest request, HttpServletResponse response, @ModelAttribute LegalCommonReportResult genericSubReportResult) throws ParseException {
        List genericSubResultList = this.genericSubReportService.getGenericSubReports(genericSubReportResult);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)genericSubResultList, LegalCommonReportResult.class, GenericSubReportJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/genericdrilldownreportresults"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<LegalCommonReportResult> getDrillDownReportResult(@ModelAttribute LegalCommonReportResult legalCommonReportObj, HttpServletRequest request) throws ParseException {
        return this.legalCommonReportService.getLegalCommonReportsResults(legalCommonReportObj, "");
    }
}

