/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.egov.lcms.masters.service.CourtTypeMasterService;
import org.egov.lcms.web.adaptor.CourtTypeMasterJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/courttypemaster"})
public class CourtTypeMasterController {
    private static final String COURTTYPEMASTER_NEW = "courttypemaster-new";
    private static final String COURTTYPEMASTER_RESULT = "courttypemaster-result";
    private static final String COURTTYPEMASTER_EDIT = "courttypemaster-edit";
    private static final String COURTTYPEMASTER_VIEW = "courttypemaster-view";
    private static final String COURTTYPEMASTER_SEARCH = "courttypemaster-search";
    @Autowired
    private CourtTypeMasterService courtTypeMasterService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("courtTypeMaster", (Object)new CourtTypeMaster());
        return COURTTYPEMASTER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CourtTypeMaster courtTypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COURTTYPEMASTER_NEW;
        }
        this.courtTypeMasterService.create(courtTypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.courtTypeMaster.success", null, null));
        return "redirect:/courttypemaster/result/" + courtTypeMaster.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CourtTypeMaster courtTypeMaster = this.courtTypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("courtTypeMaster", (Object)courtTypeMaster);
        return COURTTYPEMASTER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CourtTypeMaster courtTypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COURTTYPEMASTER_EDIT;
        }
        this.courtTypeMasterService.update(courtTypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.courtTypeMaster.update", null, null));
        return "redirect:/courttypemaster/result/" + courtTypeMaster.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CourtTypeMaster courtTypeMaster = this.courtTypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("courtTypeMaster", (Object)courtTypeMaster);
        return COURTTYPEMASTER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CourtTypeMaster courtTypeMaster = this.courtTypeMasterService.findOne(id);
        model.addAttribute("courtTypeMaster", (Object)courtTypeMaster);
        return COURTTYPEMASTER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CourtTypeMaster courtTypeMaster = new CourtTypeMaster();
        this.prepareNewForm(model);
        model.addAttribute("courtTypeMaster", (Object)courtTypeMaster);
        return COURTTYPEMASTER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CourtTypeMaster courtTypeMaster) {
        List searchResultList = this.courtTypeMasterService.search(courtTypeMaster);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CourtTypeMaster.class, (Object)new CourtTypeMasterJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

