<%--
  ~ eGov suite of products aim to improve the internal efficiency,transparency,
  ~    accountability and the service delivery of the government  organizations.
  ~
  ~     Copyright (C) <2015>  eGovernments Foundation
  ~
  ~     The updated version of eGov suite of products as by eGovernments Foundation
  ~     is available at http://www.egovernments.org
  ~
  ~     This program is free software: you can redistribute it and/or modify
  ~     it under the terms of the GNU General Public License as published by
  ~     the Free Software Foundation, either version 3 of the License, or
  ~     any later version.
  ~
  ~     This program is distributed in the hope that it will be useful,
  ~     but WITHOUT ANY WARRANTY; without even the implied warranty of
  ~     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  ~     GNU General Public License for more details.
  ~
  ~     You should have received a copy of the GNU General Public License
  ~     along with this program. If not, see http://www.gnu.org/licenses/ or
  ~     http://www.gnu.org/licenses/gpl.html .
  ~
  ~     In addition to the terms of the GPL license to be adhered to in using this
  ~     program, the following additional terms are to be complied with:
  ~
  ~         1) All versions of this program, verbatim or modified must carry this
  ~            Legal Notice.
  ~
  ~         2) Any misrepresentation of the origin of the material is prohibited. It
  ~            is required that all modified versions of this material be marked in
  ~            reasonable ways as different from the original version.
  ~
  ~         3) This license does not grant any rights to any user of the program
  ~            with regards to rights under trademark law for use of the trade names
  ~            or trademarks of eGovernments Foundation.
  ~
  ~   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
  --%>

<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<form:form method="post" action="create"
	class="form-horizontal form-groups-bordered" modelAttribute="legalCase"
	id="legalCaseForm">
	<input type="hidden" name="mode" value="${mode}" />
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-primary" data-collapsed="0">
				<div class="panel-body custom-form ">
					<c:if test="${not empty message}">
						<div class=role="alert">${message}</div>
					</c:if>
					<div class="panel-heading">
						<div class="panel-title">
							<spring:message code="title.legalCase.view" />
						</div>
					</div>
					<div class="panel-body">
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.courttype" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.courtMaster.courtType.courtType}" />
							</div>

							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.petitiontype" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.petitionTypeMaster.petitionType}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.court" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.courtMaster.name}" />
							</div>
							<div class="col-xs-3 add-margin">Case Type</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.caseTypeMaster.caseType}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.casenumber" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.caseNumber}" />
							</div>
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.lcnumber" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.lcNumber}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.casedate" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								<fmt:formatDate pattern="dd/MM/yyyy"
									value="${legalCase.caseDate}" var="casedate" />
								<c:out value="${casedate}" />
							</div>
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.previouscaseNumber" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.appealNum}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.title" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.caseTitle}" />
							</div>
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.prayer" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.prayer}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.case.receivingdate" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								<fmt:formatDate pattern="dd/MM/yyyy"
									value="${legalCase.caseReceivingDate}" var="casercdate" />
								<c:out value="${casercdate}" />
							</div>
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.caDue.date" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								<fmt:formatDate pattern="dd/MM/yyyy"
									value="${legalCase.caDueDate}" var="caduedate" />
								<c:out value="${caduedate}" />
							</div>
						</div>
						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.officerincharge" />
							</div>
							<div class="col-xs-3 add-margin view-content">
								<c:out value="${legalCase.officerIncharge.name}" />
							</div>


							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.noticedate" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								<fmt:formatDate pattern="dd/MM/yyyy"
									value="${legalCase.noticeDate}" var="noticeDate" />
								<c:out value="${noticeDate}" />
							</div>
						</div>

						<div class="row add-border">
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.fieldbycarp" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								${legalCase.isFiledByCorporation}</div>
							<div class="col-xs-3 add-margin">
								<spring:message code="lbl.oldreferencenumber" />
							</div>
							<div class="col-sm-3 add-margin view-content">
								${legalCase.oldReferenceNumber}</div>
						</div>


					</div>

				</div>
			</div>
		<div class="panel-heading">
			<div class="panel-title">
				<spring:message code="lbl.bipartisanDetails.details" />
			</div>
		</div>
		<table class="table table-striped table-bordered" id="petitionDetails">
			<thead>
				<tr>
					<th class="text-center"><spring:message code="lbl.slno" /> <%-- <th class="text-center"><spring:message code="lbl.IsGovtDept" /></th> --%>
					<th class="text-center"><spring:message code="lbl.name" /><span
						class="mandatory"></span></th>
					<th class="text-center"><spring:message code="lbl.discription" /></th>
					<th class="text-center"><spring:message
							code="lbl.contactnumber" /></th>
					<%-- <th class="text-center"><spring:message code="lbl.Govt_Dept" /></th> --%>
				</tr>
			</thead>
			<tbody>

				<c:forEach var="bipartisanPetitionDetailsList"
					items="${legalCase.getPetitioners()}" varStatus="status">
					<tr>
						<td><input type="text" id="table_name${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center" value="${status.index+1}" /></td>
						<%-- <td>
								<form:input type="hidden"
									id="bipartisanPetitionDetailsList[${status.index}].isRespondentGovernment"
									path="bipartisanPetitionDetailsList[${status.index}].isRespondentGovernment" />
									<c:choose>
							<c:when test="${bipartisanPetitionDetailsList.isRespondentGovernment}">
							<input type="checkbox" checked="true"
								id="table_isRespondentGovernment${status.index}"
								class="form-control" readonly="readonly"
								style="text-align: center"
								value="${bipartisanPetitionDetailsList.isRespondentGovernment}" /> 
								</c:when>
								<c:otherwise>
								<input type="checkbox"
										id="table_isRespondentGovernment${status.index}"
										class="form-control" readonly="readonly" style="text-align: center"
										value="${bipartisanPetitionDetailsList.isRespondentGovernment}" />
								</c:otherwise>
								</c:choose>
												</td> --%>
						<td><form:input type="hidden"
								id="bipartisanPetitionDetailsList[${status.index}].name"
								path="bipartisanPetitionDetailsList[${status.index}].name" /> <input
							type="text" id="table_name${status.index}" class="form-control"
							readonly="readonly" style="text-align: center"
							value="${bipartisanPetitionDetailsList.name}" /></td>
						<td><form:input type="hidden"
								id="bipartisanPetitionDetailsList[${status.index}].address"
								path="bipartisanPetitionDetailsList[${status.index}].address" />
							<input type="text" id="table_address${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center"
							value="${bipartisanPetitionDetailsList.address}" /></td>

						<td><form:input type="hidden"
								id="bipartisanPetitionDetailsList[${status.index}].contactNumber"
								path="bipartisanPetitionDetailsList[${status.index}].contactNumber" />
							<input type="text" id="table_contactNumber${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center"
							value="${bipartisanPetitionDetailsList.contactNumber}" /></td>

						<%-- <td>
								<form:input
									type="hidden"
									id="bipartisanPetitionDetailsList[${status.index}].governmentDepartment"
									path="bipartisanPetitionDetailsList[${status.index}].governmentDepartment" />
								<input type="text"
								id="table_governmentDepartment${status.index}"
								class="form-control" readonly="readonly"
								style="text-align: center"
								value="${bipartisanPetitionDetailsList.governmentDepartment.name}" /></td>
 --%>
					</tr>
				</c:forEach>
			</tbody>
		</table>
		<div class="panel-heading">
			<div class="panel-title">
				<spring:message code="lbl.bipartisanDetails.respondant" />
			</div>
		</div>
		<table class="table table-striped table-bordered"
			id="respondantDetails">
			<thead>
				<tr>
					<th class="text-center"><spring:message code="lbl.slno" /> <%-- <th class="text-center"><spring:message code="lbl.IsGovtDept" /></th> --%>
					<th class="text-center"><spring:message code="lbl.name" /><span
						class="mandatory"></span></th>
					<th class="text-center"><spring:message code="lbl.discription" /></th>
					<th class="text-center"><spring:message
							code="lbl.contactnumber" /></th>
					<%-- <th class="text-center"><spring:message code="lbl.Govt_Dept" /></th> --%>
				</tr>
			</thead>
			<tbody>
				<c:forEach var="bipartisanDetailsBeanList"
					items="${legalCase.getRespondents()}" varStatus="status">
					<tr>
						<td><input type="text" id="table_name${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center" value="${status.index+1}" /></td>
						<%-- <td>
							<form:input type="hidden"
									id="bipartisanDetailsBeanList[${status.index}].isRespondentGovernment"
									path="bipartisanDetailsBeanList[${status.index}].isRespondentGovernment" />
									<c:choose>
							<c:when test="${bipartisanDetailsBeanList.isRespondentGovernment}">
							<input type="checkbox" checked="true"
								id="table_isRespondentGovernment${status.index}"
								class="form-control" readonly="readonly"
								style="text-align: center"
								value="${bipartisanDetailsBeanList.isRespondentGovernment}" /> 
								</c:when>
								<c:otherwise>
								<input type="checkbox" 
								id="table_isRespondentGovernment${status.index}"
								class="form-control" readonly="readonly"
								style="text-align: center"
								value="${bipartisanDetailsBeanList.isRespondentGovernment}" /> 
								
								</c:otherwise>
								</c:choose>
								</td> --%>

						<td><form:input type="hidden"
								id="bipartisanDetailsBeanList[${status.index}].name"
								path="bipartisanDetailsBeanList[${status.index}].name" /> <input
							type="text" id="table_name${status.index}" class="form-control"
							readonly="readonly" style="text-align: center"
							value="${bipartisanDetailsBeanList.name}" /></td>

						<td><form:input type="hidden"
								id="bipartisanDetailsBeanList[${status.index}].address"
								path="bipartisanDetailsBeanList[${status.index}].address" /> <input
							type="text" id="table_address${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center"
							value="${bipartisanDetailsBeanList.address}" /></td>

						<td><form:input type="hidden"
								id="bipartisanDetailsBeanList[${status.index}].contactNumber"
								path="bipartisanDetailsBeanList[${status.index}].contactNumber" />
							<input type="text" id="table_contactNumber${status.index}"
							class="form-control" readonly="readonly"
							style="text-align: center"
							value="${bipartisanDetailsBeanList.contactNumber}" /></td>

						<%-- <td>
								<form:input type="hidden"
									id="bipartisanDetailsBeanList[${status.index}].governmentDepartment"
									path="bipartisanDetailsBeanList[${status.index}].governmentDepartment" />
								<input type="text"
								id="table_governmentDepartment${status.index}"
								class="form-control" readonly="readonly"
								style="text-align: center"
								value="${bipartisanDetailsBeanList.governmentDepartment.name}" /></td>
 --%>
					</tr>
				</c:forEach>
			</tbody>
		</table>
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-primary" data-collapsed="0">
				<div class="panel-body">
					<div class="row add-border">
						<div class="col-md-2 col-xs-6 add-margin">
							<spring:message code="lbl.representedby" />
						</div>
						<div class="col-md-3 col-xs-6 add-margin view-content">
							<c:out value="${legalCase.representedby}" />
						</div>
						<div class="col-md-2 col-xs-6 add-margin">Standing Council
							Name</div>
						<div class="col-md-3 col-xs-6 add-margin view-content">
							<c:out value="${legalCase.oppPartyAdvocate}" />
						</div>
					</div>
					<div class="row add-border">
						<div class="col-md-2 col-xs-6 add-margin">Remarks</div>
						<div class="col-md-3 col-xs-6 add-margin view-content">
							<c:out value="${legalCase.remarks}" />
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<jsp:include page="documentdetails-view.jsp"></jsp:include>
	<div class="form-group">
		<div class="text-center">
			<a href="javascript:void(0)" class="btn btn-default"
				onclick="self.close()"><spring:message code="lbl.close" /></a>
		</div>
	</div>
	</div>
	</div>
</form:form>
