/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/counterAffidavit"})
public class CounterAffidavitController {
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @RequestMapping(value={"/create/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="legalCase") LegalCase legalCase, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        if (legalCase.getCounterAffidavits().isEmpty()) {
            model.addAttribute("mode", (Object)"countercreate");
            model.addAttribute("legalCase", (Object)legalCase);
        } else {
            LegalCase newlegalCase = this.getPwrDocuments(legalCase);
            model.addAttribute("mode", (Object)"counteredit");
            model.addAttribute("legalCase", (Object)newlegalCase);
        }
        return "legalcase-caaffidavit";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalcase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalcase;
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="legalCase") LegalCase legalCase, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, @RequestParam(value="file") MultipartFile[] files, Model model) throws IOException, ParseException {
        if (errors.hasErrors()) {
            return "legalcase-caaffidavit";
        }
        this.legalCaseService.update(legalCase, files);
        redirectAttrs.addFlashAttribute("legalCase", (Object)legalCase);
        model.addAttribute("message", (Object)"Counter Affidavit Details Saved Successfully.");
        LegalCase newlegalCase = this.getPwrDocuments(legalCase);
        model.addAttribute("legalcase", (Object)newlegalCase);
        model.addAttribute("mode", (Object)"view");
        return "legalcase-ca-success";
    }

    private LegalCase getPwrDocuments(LegalCase legalCase) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.legalCaseUtil.getPwrDocumentList(legalCase);
        ((Pwr)legalCase.getPwrList().get(0)).setPwrDocuments(documentDetailsList);
        return legalCase;
    }
}

