/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.utils.JsonUtils;
import org.egov.lcms.reports.entity.TimeSeriesReportResult;
import org.egov.lcms.transactions.service.TimeSeriesReportService;
import org.egov.lcms.web.adaptor.DrillDownReportJsonAdaptor;
import org.egov.lcms.web.adaptor.TimeSeriesReportJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/timeseriesreports"})
public class TimeSeriesReportController {
    @Autowired
    private TimeSeriesReportService timeSeriesReportService;

    @ModelAttribute(value="aggregatedByList")
    public List<String> getAggregatedBy() {
        ArrayList<String> aggregatedByList = new ArrayList<String>();
        aggregatedByList.add("Court Name");
        aggregatedByList.add("Petition Type");
        aggregatedByList.add("Case Status");
        aggregatedByList.add("Case Category");
        aggregatedByList.add("Court Type");
        aggregatedByList.add("In charge officer");
        aggregatedByList.add("Standing Counsel");
        return aggregatedByList;
    }

    @ModelAttribute(value="period")
    public List<String> getPeriod() {
        ArrayList<String> period = new ArrayList<String>();
        period.add("Year");
        period.add("Month");
        return period;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/timeSeriesReport"})
    public String searchForm(Model model) {
        model.addAttribute("timeSeriesReportResult", (Object)new TimeSeriesReportResult());
        model.addAttribute("currentDate", (Object)new Date());
        return "timeseriesreport-form";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/timeSeriesReportresults"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getTimeSeriesReportResult(@RequestParam String aggregatedBy, @RequestParam String period, @RequestParam Date fromDate, @RequestParam Date toDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TimeSeriesReportResult timeSeriesReportObj = new TimeSeriesReportResult();
        timeSeriesReportObj.setAggregatedBy(aggregatedBy);
        timeSeriesReportObj.setPeriod(period);
        timeSeriesReportObj.setFromDate(fromDate);
        timeSeriesReportObj.setToDate(toDate);
        Boolean clickOnCount = Boolean.FALSE;
        List timeSeriesReportList = this.timeSeriesReportService.getTimeSeriesReports(timeSeriesReportObj, clickOnCount);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)timeSeriesReportList, TimeSeriesReportResult.class, TimeSeriesReportJsonAdaptor.class) + "}";
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/drilldownreportresult"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getDrillDownReportResult(@RequestParam String aggregatedBy, @RequestParam String aggregatedByValue, @RequestParam String month, @RequestParam Integer year, @RequestParam String period, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TimeSeriesReportResult timeSeriesReportObj = new TimeSeriesReportResult();
        timeSeriesReportObj.setAggregatedBy(aggregatedBy);
        timeSeriesReportObj.setYear(year);
        timeSeriesReportObj.setMonth(month);
        timeSeriesReportObj.setPeriod(period);
        timeSeriesReportObj.setAggregatedByValue(aggregatedByValue);
        Boolean clickOnCount = Boolean.TRUE;
        List timeSeriesReportList = this.timeSeriesReportService.getTimeSeriesReports(timeSeriesReportObj, clickOnCount);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)timeSeriesReportList, TimeSeriesReportResult.class, DrillDownReportJsonAdaptor.class) + "}";
        return result;
    }
}

