/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.PetitionTypeMaster;
import org.egov.lcms.masters.service.CourtTypeMasterService;
import org.egov.lcms.masters.service.PetitionTypeMasterService;
import org.egov.lcms.web.adaptor.PetitionTypeMasterJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/petitiontypemaster"})
public class PetitionTypeMasterController {
    private static final String PETITIONTYPEMASTER_NEW = "petitiontypemaster-new";
    private static final String PETITIONTYPEMASTER_RESULT = "petitiontypemaster-result";
    private static final String PETITIONTYPEMASTER_EDIT = "petitiontypemaster-edit";
    private static final String PETITIONTYPEMASTER_VIEW = "petitiontypemaster-view";
    private static final String PETITIONTYPEMASTER_SEARCH = "petitiontypemaster-search";
    @Autowired
    private PetitionTypeMasterService petitionTypeMasterService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CourtTypeMasterService courtTypeMasterService;

    private void prepareNewForm(Model model) {
        model.addAttribute("courtTypeMasters", (Object)this.courtTypeMasterService.getActiveCourtTypes());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("petitionTypeMaster", (Object)new PetitionTypeMaster());
        return PETITIONTYPEMASTER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute PetitionTypeMaster petitionTypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return PETITIONTYPEMASTER_NEW;
        }
        this.petitionTypeMasterService.create(petitionTypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.petitionTypeMaster.success", null, null));
        return "redirect:/petitiontypemaster/result/" + petitionTypeMaster.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        PetitionTypeMaster petitionTypeMaster = this.petitionTypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("petitionTypeMaster", (Object)petitionTypeMaster);
        return PETITIONTYPEMASTER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute PetitionTypeMaster petitionTypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return PETITIONTYPEMASTER_EDIT;
        }
        this.petitionTypeMasterService.update(petitionTypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.petitionTypeMaster.update", null, null));
        return "redirect:/petitiontypemaster/result/" + petitionTypeMaster.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        PetitionTypeMaster petitionTypeMaster = this.petitionTypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("petitionTypeMaster", (Object)petitionTypeMaster);
        return PETITIONTYPEMASTER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        PetitionTypeMaster petitionTypeMaster = this.petitionTypeMasterService.findOne(id);
        model.addAttribute("petitionTypeMaster", (Object)petitionTypeMaster);
        return PETITIONTYPEMASTER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        PetitionTypeMaster petitionTypeMaster = new PetitionTypeMaster();
        this.prepareNewForm(model);
        model.addAttribute("petitionTypeMaster", (Object)petitionTypeMaster);
        return PETITIONTYPEMASTER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute PetitionTypeMaster petitionTypeMaster) {
        List searchResultList = this.petitionTypeMasterService.search(petitionTypeMaster);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(PetitionTypeMaster.class, (Object)new PetitionTypeMasterJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

